/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.tile;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlock;
import iskallia.vault.core.world.data.tile.PartialBlockProperties;
import iskallia.vault.core.world.data.tile.TilePlacement;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PartialBlockState
implements TilePlacement<PartialBlockState> {
    private PartialBlock block;
    private PartialBlockProperties properties;

    protected PartialBlockState(PartialBlock block, PartialBlockProperties properties) {
        this.block = block;
        this.properties = properties;
    }

    public static PartialBlockState of(PartialBlock block, PartialBlockProperties properties) {
        return new PartialBlockState(block, properties);
    }

    public static PartialBlockState of(Block block) {
        return new PartialBlockState(PartialBlock.of(block), PartialBlockProperties.empty());
    }

    public static PartialBlockState of(BlockState state) {
        return new PartialBlockState(PartialBlock.of(state), PartialBlockProperties.of(state));
    }

    public static PartialBlockState at(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return new PartialBlockState(PartialBlock.of(state), PartialBlockProperties.of(state));
    }

    public PartialBlock getBlock() {
        return this.block;
    }

    public PartialBlockProperties getProperties() {
        return this.properties;
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        return this.properties.get(property);
    }

    public <T extends Comparable<T>, V extends T> PartialBlockState set(Property<T> property, V value) {
        this.properties.set(property, value);
        return this;
    }

    @Override
    public boolean isSubsetOf(PartialBlockState other) {
        if (!this.block.isSubsetOf(other.block)) {
            return false;
        }
        return this.properties.isSubsetOf(other.properties);
    }

    @Override
    public boolean isSubsetOf(LevelReader world, BlockPos pos) {
        return this.isSubsetOf(PartialBlockState.of(world.m_8055_(pos)));
    }

    @Override
    public void fillInto(PartialBlockState other) {
        this.block.fillInto(other.block);
        this.properties.fillInto(other.properties);
    }

    @Override
    public void place(CommonLevelAccessor world, BlockPos pos, int flags) {
        this.asWhole().ifPresent(state -> world.m_7731_(pos, state, flags));
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state);
    }

    public Optional<BlockState> asWhole() {
        return this.block.asWhole().map(block -> this.properties.apply(block.m_49966_()));
    }

    public void mapAndSet(UnaryOperator<BlockState> mapper) {
        this.asWhole().ifPresent(oldState -> {
            BlockState newState = (BlockState)mapper.apply((BlockState)oldState);
            if (oldState == newState) {
                return;
            }
            PartialBlock.of(newState.m_60734_()).fillInto(this.block);
            PartialBlockProperties.of(newState).fillInto(this.properties);
        });
    }

    public void mirror(Mirror mirror) {
        this.mapAndSet(state -> state.m_60715_(mirror));
    }

    public void rotate(Rotation rotation) {
        this.mapAndSet(state -> state.m_60717_(rotation));
    }

    public boolean is(Block block) {
        return this.block.asWhole().map(value -> block == value).orElse(false);
    }

    @Override
    public PartialBlockState copy() {
        return PartialBlockState.of(this.block.copy(), this.properties.copy());
    }

    public String toString() {
        return this.block.toString() + this.properties.toString();
    }

    public static Optional<PartialBlockState> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlockState.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlockState parse(String string) throws CommandSyntaxException {
        return PartialBlockState.parse(new StringReader(string));
    }

    public static PartialBlockState parse(StringReader reader) throws CommandSyntaxException {
        return PartialBlockState.of(PartialBlock.parse(reader), PartialBlockProperties.parse(reader));
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlockState, Tag, JsonElement> {
        @Override
        public Optional<Tag> writeNbt(@Nullable PartialBlockState value) {
            if (value == null) {
                return Optional.empty();
            }
            CompoundTag nbt = new CompoundTag();
            Adapters.PARTIAL_BLOCK.writeNbt(value.block).ifPresent(tag -> nbt.m_128365_("Name", tag));
            Adapters.PARTIAL_BLOCK_PROPERTIES.writeNbt(value.properties).ifPresent(tag -> nbt.m_128365_("Properties", tag));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialBlockState> readNbt(@Nullable Tag nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                return Optional.of(PartialBlockState.of(Adapters.PARTIAL_BLOCK.readNbt(compound.m_128423_("Name")).orElseGet(PartialBlock::empty), Adapters.PARTIAL_BLOCK_PROPERTIES.readNbt(compound.m_128423_("Properties")).orElseGet(PartialBlockProperties::empty)));
            }
            return Optional.empty();
        }
    }
}

