/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.tile;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.OrTilePredicate;
import iskallia.vault.core.world.data.tile.PartialBlockGroup;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialBlockTag;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@FunctionalInterface
public interface TilePredicate {
    public static final TilePredicate FALSE = (state, nbt) -> false;
    public static final TilePredicate TRUE = (state, nbt) -> true;

    public boolean test(PartialBlockState var1, PartialCompoundNbt var2);

    default public boolean test(PartialTile tile) {
        return this.test(tile.getState(), tile.getEntity());
    }

    default public boolean test(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        BlockEntity entity = world.m_7702_(pos);
        return this.test(PartialBlockState.of(state), PartialCompoundNbt.of(entity));
    }

    public static TilePredicate of(Block block) {
        return (state, nbt) -> state.getBlock().asWhole().map(other -> other == block).orElse(false);
    }

    public static Optional<TilePredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialBlockTag.parse(string, logErrors);
            case '@' -> PartialBlockGroup.parse(string, logErrors);
            default -> PartialTile.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<TilePredicate, Tag, JsonElement> {
        private static ArrayAdapter<TilePredicate> LIST = Adapters.ofArray(TilePredicate[]::new, new Adapter());

        @Override
        public void writeBits(@Nullable TilePredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrTilePredicate) {
                    OrTilePredicate or = (OrTilePredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((TilePredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<TilePredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrTilePredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> TilePredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable TilePredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrTilePredicate) {
                OrTilePredicate or = (OrTilePredicate)value;
                return LIST.writeNbt((TilePredicate)or.getChildren());
            }
            return Optional.of(StringTag.m_129297_((String)value.toString()));
        }

        @Override
        public Optional<TilePredicate> readNbt(@Nullable Tag nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof ListTag) {
                ListTag list = (ListTag)nbt;
                return LIST.readNbt(list).map(OrTilePredicate::new);
            }
            if (nbt instanceof StringTag) {
                StringTag string = (StringTag)nbt;
                return Optional.of(TilePredicate.of(string.m_7916_(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(@Nullable TilePredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrTilePredicate) {
                OrTilePredicate or = (OrTilePredicate)value;
                return LIST.writeJson((TilePredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<TilePredicate> readJson(@Nullable JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrTilePredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(TilePredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

