/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.RegistryValueAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.MathUtils;
import iskallia.vault.core.util.ObjectCache;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.configured.ChunkedTemplate;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.mixin.AccessorChunkMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.commons.lang3.mutable.MutableObject;

public class GridGenerator
extends VaultGenerator {
    public static final SupplierKey<GridGenerator> KEY = (SupplierKey)SupplierKey.of("grid", GridGenerator.class).with(Version.v1_0, (GridGenerator)((Object)((Supplier<GridGenerator>)GridGenerator::new)));
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Integer> CELL_X = (FieldKey)FieldKey.of("cell_x", Integer.class).with(Version.v1_0, Adapters.ofBoundedInt(1, 256), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> CELL_Z = (FieldKey)FieldKey.of("cell_z", Integer.class).with(Version.v1_0, Adapters.ofBoundedInt(1, 256), DISK.all()).register(FIELDS);
    public static final FieldKey<GridLayout> LAYOUT = (FieldKey)FieldKey.of("layout", GridLayout.class).with(Version.v1_0, RegistryValueAdapter.of(() -> VaultRegistry.GRID_LAYOUT, ISupplierKey::getKey, Supplier::get), DISK.all()).register(FIELDS);
    protected ObjectCache<RegionPos, ConfiguredTemplate> cache;

    @Override
    public SupplierKey<GridGenerator> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        this.cache = new ObjectCache(world.m_46469_().m_46215_(ModGameRules.TEMPLATE_CACHE_SIZE), region -> MathUtils.mask(region.m_123341_(), 31) | MathUtils.mask(region.m_123343_(), 31) << 32);
        this.get(LAYOUT).initServer(world, vault, this);
        super.initServer(world, vault);
    }

    @Override
    public void releaseServer() {
        this.cache = null;
        this.get(LAYOUT).releaseServer();
        super.releaseServer();
    }

    @Override
    public void generate(Vault vault, ServerLevelAccessor world, ChunkPos chunkPos) {
        BlockPos pos1 = new BlockPos(chunkPos.f_45578_ * 16, Integer.MIN_VALUE, chunkPos.f_45579_ * 16);
        BlockPos pos2 = new BlockPos(chunkPos.f_45578_ * 16 + 15, Integer.MAX_VALUE, chunkPos.f_45579_ * 16 + 15);
        int offsetX = Math.floorMod(pos1.m_123341_(), (int)this.get(CELL_X));
        int offsetZ = Math.floorMod(pos1.m_123343_(), (int)this.get(CELL_Z));
        for (int x = pos1.m_123341_(); x <= pos2.m_123341_(); x += this.get(CELL_X) - offsetX) {
            for (int z = pos1.m_123343_(); z <= pos2.m_123343_(); z += this.get(CELL_Z) - offsetZ) {
                ConfiguredTemplate template;
                RegionPos region = RegionPos.ofBlockPos(new BlockPos(x, 0, z), this.get(CELL_X), this.get(CELL_Z));
                ChunkRandom random = ChunkRandom.any();
                if (vault.get(Vault.VERSION).isOlderThan(Version.v1_7)) {
                    random.setCarverSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_());
                } else {
                    random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
                }
                if (this.cache == null) {
                    return;
                }
                if (this.cache.has(region)) {
                    template = this.cache.get(region);
                } else {
                    PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(3);
                    template = this.get(LAYOUT).getAt(vault, region, random, settings).configure(ChunkedTemplate::new, settings);
                    if (template.getParent() != EmptyTemplate.INSTANCE) {
                        this.cache.set(region, template);
                    }
                }
                if (template == null) continue;
                template = CommonEvents.TEMPLATE_GENERATION.invoke(world, template, region, chunkPos, random, TemplateGenerationEvent.Phase.PRE).getTemplate();
                template.place(world, chunkPos);
                CommonEvents.TEMPLATE_GENERATION.invoke(world, template, region, chunkPos, random, TemplateGenerationEvent.Phase.POST);
            }
        }
    }

    public void generate(Vault vault, ServerLevelAccessor world, RegionPos region) {
        ServerChunkCache source;
        int maxZ;
        int maxX;
        block9: {
            block8: {
                ChunkPos chunkPos;
                int z;
                int x;
                ChunkRandom random = ChunkRandom.any();
                random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
                PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(272);
                ConfiguredTemplate template = this.get(LAYOUT).getAt(vault, region, random, settings).configure(ConfiguredTemplate::new, settings);
                int minX = region.m_123341_() * region.getSizeX();
                maxX = minX + region.getSizeX();
                int minZ = region.m_123343_() * region.getSizeZ();
                maxZ = minZ + region.getSizeZ();
                for (x = minX; x < maxX; x += x + 16 < maxX ? 16 : 16 - Math.floorMod(x, 16)) {
                    for (z = minZ; z < maxZ; z += z + 16 < maxZ ? 16 : 16 - Math.floorMod(z, 16)) {
                        chunkPos = new ChunkPos(x >> 4, z >> 4);
                        CommonEvents.TEMPLATE_GENERATION.invoke(world, template, region, chunkPos, random, TemplateGenerationEvent.Phase.PRE);
                    }
                }
                template.place(world, null);
                for (x = minX; x < maxX; x += x + 16 < maxX ? 16 : 16 - Math.floorMod(x, 16)) {
                    for (z = minZ; z < maxZ; z += z + 16 < maxZ ? 16 : 16 - Math.floorMod(z, 16)) {
                        chunkPos = new ChunkPos(x >> 4, z >> 4);
                        CommonEvents.TEMPLATE_GENERATION.invoke(world, template, region, chunkPos, random, TemplateGenerationEvent.Phase.POST);
                    }
                }
                ChunkSource z2 = world.m_7726_();
                if (!(z2 instanceof ServerChunkCache)) break block8;
                source = (ServerChunkCache)z2;
                if (world.m_142572_() != null) break block9;
            }
            return;
        }
        for (int x = minX; x < maxX; x += x + 16 < maxX ? 16 : 16 - Math.floorMod(x, 16)) {
            for (int z = minZ; z < maxZ; z += z + 16 < maxZ ? 16 : 16 - Math.floorMod(z, 16)) {
                ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
                world.m_142572_().m_6937_((Runnable)new TickTask(world.m_142572_().m_129921_() + 1, () -> source.f_8325_.m_183262_(chunkPos, false).forEach(player -> {
                    world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                    ((AccessorChunkMap)source.f_8325_).callUpdateChunkTracking((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                })));
            }
        }
    }
}

