/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.world.storage.IntLatch;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;

public class TemplateCache {
    private final Map<RegionPos, ConfiguredTemplate> templates = Collections.synchronizedMap(new HashMap());
    private final Map<RegionPos, IntLatch> locks = Collections.synchronizedMap(new HashMap());
    private final int size;

    public TemplateCache(int size) {
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredTemplate getOrCreate(RegionPos region, Supplier<ConfiguredTemplate> supplier) {
        IntLatch lock;
        ConfiguredTemplate template = this.templates.get((Object)region);
        if (template != null) {
            return template;
        }
        boolean lockPresent = false;
        Map<RegionPos, IntLatch> map = this.locks;
        synchronized (map) {
            if (this.locks.containsKey((Object)region)) {
                lockPresent = true;
                lock = this.locks.get((Object)region);
            } else {
                lock = new IntLatch();
                this.locks.put(region, lock);
                lock.increment();
            }
        }
        if (lockPresent) {
            try {
                lock.waitUntil(i -> i == 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.getOrCreate(region, supplier);
        }
        template = supplier.get();
        if (template != ConfiguredTemplate.EMPTY) {
            this.templates.put(region, template);
        } else {
            this.locks.remove((Object)region);
        }
        lock.decrement();
        this.clearOldRegions();
        return template;
    }

    private void clearOldRegions() {
        while (this.templates.size() > this.size) {
            Iterator<Map.Entry<RegionPos, ConfiguredTemplate>> it = this.templates.entrySet().iterator();
            this.locks.remove((Object)it.next().getKey());
            it.remove();
        }
    }
}

