/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.RegistryKeyAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.core.world.generator.layout.ClassicVaultLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class ArchitectVaultLayout
extends VaultLayout {
    public static final SupplierKey<GridLayout> KEY = (SupplierKey)SupplierKey.of("architect_vault", GridLayout.class).with(Version.v1_10, (GridLayout)((Object)((Supplier<GridLayout>)ArchitectVaultLayout::new)));
    public static final FieldRegistry FIELDS = ClassicVaultLayout.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<TemplatePoolKey> START_POOL = (FieldKey)FieldKey.of("start_pool", TemplatePoolKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.TEMPLATE_POOL), DISK.all()).register(FIELDS);
    public static final FieldKey<TemplatePoolKey> COMMON_ROOM_POOL = (FieldKey)FieldKey.of("common_room_pool", TemplatePoolKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.TEMPLATE_POOL), DISK.all()).register(FIELDS);
    public static final FieldKey<TemplatePoolKey> CHALLENGE_ROOM_POOL = (FieldKey)FieldKey.of("challenge_room_pool", TemplatePoolKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.TEMPLATE_POOL), DISK.all()).register(FIELDS);
    public static final FieldKey<TemplatePoolKey> OMEGA_ROOM_POOL = (FieldKey)FieldKey.of("omega_room_pool", TemplatePoolKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.TEMPLATE_POOL), DISK.all()).register(FIELDS);
    public static final FieldKey<TemplatePoolKey> TUNNEL_POOL = (FieldKey)FieldKey.of("tunnel_pool", TemplatePoolKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.TEMPLATE_POOL), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> TUNNEL_SPAN = (FieldKey)FieldKey.of("tunnel_span", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all()).register(FIELDS);
    public static final FieldKey<ArchitectRoomEntry.List> ROOM_ENTRIES = (FieldKey)FieldKey.of("room_entries", ArchitectRoomEntry.List.class).with(Version.v1_0, CompoundAdapter.of(ArchitectRoomEntry.List::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Float> COMPLETION = (FieldKey)FieldKey.of("completion", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all()).register(FIELDS);

    protected ArchitectVaultLayout() {
        this.set(ROOM_ENTRIES, new ArchitectRoomEntry.List());
    }

    public ArchitectVaultLayout(int tunnelSpan, Collection<ArchitectRoomEntry> roomEntries, float completion) {
        this();
        this.set(TUNNEL_SPAN, tunnelSpan);
        this.get(ROOM_ENTRIES).addAll(roomEntries);
        this.set(COMPLETION, Float.valueOf(completion));
    }

    @Override
    public SupplierKey<GridLayout> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, GridGenerator generator) {
        super.initServer(world, vault, generator);
        CommonEvents.TEMPLATE_GENERATION.at(TemplateGenerationEvent.Phase.PRE).in((LevelWriter)world).register(this, data -> data.getTemplate().getSettings().addProcessor(TileProcessor.of((tile, context) -> {
            tile.getState().asWhole().ifPresent(state -> {
                if (!ModConfigs.ARCHITECT.isWhitelisted((PartialTile)tile)) {
                    if (ModConfigs.ARCHITECT.isBlacklisted((PartialTile)tile)) {
                        tile.setState(PartialBlockState.of(Blocks.f_50016_));
                    } else if (context.getRandom(tile.getPos()).nextFloat() >= this.get(COMPLETION).floatValue()) {
                        if (state.m_60838_((BlockGetter)data.getWorld(), tile.getPos())) {
                            tile.setState(PartialBlockState.of(ModBlocks.VAULT_BEDROCK));
                        } else {
                            tile.setState(PartialBlockState.of(Blocks.f_50016_));
                        }
                    }
                }
            });
            return tile;
        })));
    }

    @Override
    public VaultLayout.PieceType getType(Vault vault, RegionPos region) {
        VaultLayout.PieceType type = this.getBaseType(vault, region);
        int unit = this.get(TUNNEL_SPAN) + 1;
        int x = region.m_123341_();
        int z = region.m_123343_();
        if (type == VaultLayout.PieceType.ROOM) {
            int count = this.get(ROOM_ENTRIES).getTotalCount();
            Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
            int index = this.getSpiralIndex(x / unit, z / unit, facing, Rotation.CLOCKWISE_90) - 1;
            return index < count ? VaultLayout.PieceType.ROOM : VaultLayout.PieceType.NONE;
        }
        if (type == VaultLayout.PieceType.TUNNEL_X) {
            int xRoom1 = x - Math.floorMod(x, unit);
            int xRoom2 = xRoom1 + unit;
            if (!this.getType(vault, region.with(xRoom1, z)).connectsToTunnel()) {
                return VaultLayout.PieceType.NONE;
            }
            if (!this.getType(vault, region.with(xRoom2, z)).connectsToTunnel()) {
                return VaultLayout.PieceType.NONE;
            }
        } else if (type == VaultLayout.PieceType.TUNNEL_Z) {
            int zRoom1 = z - Math.floorMod(z, unit);
            int zRoom2 = zRoom1 + unit;
            if (!this.getType(vault, region.with(x, zRoom1)).connectsToTunnel()) {
                return VaultLayout.PieceType.NONE;
            }
            if (!this.getType(vault, region.with(x, zRoom2)).connectsToTunnel()) {
                return VaultLayout.PieceType.NONE;
            }
        }
        return type;
    }

    public VaultLayout.PieceType getBaseType(Vault vault, RegionPos region) {
        int x = region.m_123341_();
        int z = region.m_123343_();
        int unit = this.get(TUNNEL_SPAN) + 1;
        if (x == 0 && z == 0) {
            return VaultLayout.PieceType.START;
        }
        if (x % unit == 0 && z % unit == 0) {
            return VaultLayout.PieceType.ROOM;
        }
        if (x % unit != 0 && z % unit != 0) {
            return VaultLayout.PieceType.NONE;
        }
        Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
        int distance = Math.abs(x) + Math.abs(z);
        if (x % unit == 0) {
            return distance < unit && z * facing.m_122431_() <= 0 ? VaultLayout.PieceType.NONE : VaultLayout.PieceType.TUNNEL_Z;
        }
        if (z % unit == 0) {
            return distance < unit && x * facing.m_122429_() <= 0 ? VaultLayout.PieceType.NONE : VaultLayout.PieceType.TUNNEL_X;
        }
        throw new IllegalStateException("You have stumbled upon a number that doesn't exist");
    }

    @Override
    public Template getTemplate(VaultLayout.PieceType type, Vault vault, RegionPos region, RandomSource random, PlacementSettings settings) {
        Version version = vault.get(Vault.VERSION);
        return switch (this.getType(vault, region)) {
            default -> throw new IncompatibleClassChangeError();
            case VaultLayout.PieceType.NONE -> EmptyTemplate.INSTANCE;
            case VaultLayout.PieceType.START -> this.getStart((TemplatePool)this.get(START_POOL).get(version), vault.get(Vault.VERSION), region, random, vault.get(Vault.WORLD).get(WorldManager.FACING), settings);
            case VaultLayout.PieceType.START_NORTH -> this.getStart((TemplatePool)this.get(START_POOL).get(version), vault.get(Vault.VERSION), region, random, Direction.NORTH, settings);
            case VaultLayout.PieceType.START_SOUTH -> this.getStart((TemplatePool)this.get(START_POOL).get(version), vault.get(Vault.VERSION), region, random, Direction.SOUTH, settings);
            case VaultLayout.PieceType.START_WEST -> this.getStart((TemplatePool)this.get(START_POOL).get(version), vault.get(Vault.VERSION), region, random, Direction.WEST, settings);
            case VaultLayout.PieceType.START_EAST -> this.getStart((TemplatePool)this.get(START_POOL).get(version), vault.get(Vault.VERSION), region, random, Direction.EAST, settings);
            case VaultLayout.PieceType.ROOM -> {
                int unit = this.get(TUNNEL_SPAN) + 1;
                int x = region.m_123341_();
                int z = region.m_123343_();
                Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
                int index = this.getSpiralIndex(x / unit, z / unit, facing, Rotation.CLOCKWISE_90) - 1;
                List<TemplatePoolKey> entries = this.get(ROOM_ENTRIES).flatten(this);
                Collections.shuffle(entries, new Random(vault.get(Vault.SEED)));
                yield this.getRoom((TemplatePool)entries.get(index).get(version), vault.get(Vault.VERSION), region, random, settings);
            }
            case VaultLayout.PieceType.TUNNEL_X -> this.getTunnel((TemplatePool)this.get(TUNNEL_POOL).get(version), vault.get(Vault.VERSION), region, random, Direction.Axis.X, settings);
            case VaultLayout.PieceType.TUNNEL_Z -> this.getTunnel((TemplatePool)this.get(TUNNEL_POOL).get(version), vault.get(Vault.VERSION), region, random, Direction.Axis.Z, settings);
        };
    }

    public int getSpiralIndex(int x, int z, Direction facing, Rotation rotation) {
        switch (facing) {
            case SOUTH: {
                if (rotation != Rotation.COUNTERCLOCKWISE_90) break;
                x *= -1;
                break;
            }
            case NORTH: {
                if (rotation == Rotation.CLOCKWISE_180) {
                    x *= -1;
                }
                z *= -1;
                break;
            }
            case EAST: {
                int temp = x;
                x = rotation == Rotation.CLOCKWISE_90 ? -z : z;
                z = temp;
                break;
            }
            case WEST: {
                int temp = x;
                x = rotation == Rotation.COUNTERCLOCKWISE_90 ? -z : z;
                z = -temp;
            }
        }
        int u = x + z;
        int v = x - z;
        int p = u > 0 ? (v >= 0 ? (x <<= 1) * (x - 1) + v : (z <<= 1) * (z - 1) + v) : (v < 0 ? -(x <<= 1) * (1 - x) - v : -(z <<= 1) * (1 - z) - v);
        return p;
    }
}

