/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.layout.ClassicVaultLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import java.util.function.Supplier;
import net.minecraft.core.Direction;

public class ClassicInfiniteLayout
extends ClassicVaultLayout {
    public static final SupplierKey<GridLayout> KEY = (SupplierKey)SupplierKey.of("classic_infinite_vault", GridLayout.class).with(Version.v1_0, (GridLayout)((Object)((Supplier<GridLayout>)ClassicInfiniteLayout::new)));
    public static final FieldRegistry FIELDS = ClassicVaultLayout.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> TUNNEL_SPAN = (FieldKey)FieldKey.of("tunnel_span", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all()).register(FIELDS);

    protected ClassicInfiniteLayout() {
    }

    public ClassicInfiniteLayout(int tunnelSpan) {
        this.set(TUNNEL_SPAN, tunnelSpan);
    }

    @Override
    public SupplierKey<GridLayout> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public VaultLayout.PieceType getType(Vault vault, RegionPos region) {
        boolean usesStart;
        int x = region.m_123341_();
        int z = region.m_123343_();
        int unit = this.get(TUNNEL_SPAN) + 1;
        if (x == 0 && z == 0) {
            return VaultLayout.PieceType.START;
        }
        if (x % unit == 0 && z % unit == 0) {
            return VaultLayout.PieceType.ROOM;
        }
        if (x % unit != 0 && z % unit != 0) {
            return VaultLayout.PieceType.NONE;
        }
        Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
        int distance = Math.abs(x) + Math.abs(z);
        boolean bl = usesStart = this.getType(vault, region.with(0, 0)) == VaultLayout.PieceType.START;
        if (x % unit == 0) {
            return usesStart && distance < unit && z * facing.m_122431_() <= 0 ? VaultLayout.PieceType.NONE : VaultLayout.PieceType.TUNNEL_Z;
        }
        if (z % unit == 0) {
            return usesStart && distance < unit && x * facing.m_122429_() <= 0 ? VaultLayout.PieceType.NONE : VaultLayout.PieceType.TUNNEL_X;
        }
        throw new IllegalStateException("You have stumbled upon a number that doesn't exist");
    }
}

