/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.core.world.template.data.TemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public abstract class VaultLayout
extends GridLayout {
    public static final FieldRegistry FIELDS = GridLayout.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<Void> FILL_AIR = (FieldKey)FieldKey.of("fill_stone", Void.class).with(Version.v1_19, Adapters.ofVoid(), DISK.all()).register(FIELDS);

    @Override
    public void initServer(VirtualWorld world, Vault vault, GridGenerator generator) {
        CommonEvents.NOISE_GENERATION.in(world).register(this, data -> {
            if (this.has(FILL_AIR)) {
                return;
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            BlockState state = ModBlocks.VAULT_BEDROCK.m_49966_();
            for (int y = 63; y >= 0; --y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        data.getChunk().m_6978_((BlockPos)pos.m_122178_(x, y, z), state, false);
                    }
                }
            }
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.NOISE_GENERATION.release(this);
    }

    @Override
    public Template getAt(Vault vault, RegionPos region, RandomSource random, PlacementSettings settings) {
        Template template = this.getTemplate(this.getType(vault, region), vault, region, random, settings);
        if (template instanceof JigsawTemplate) {
            JigsawTemplate jigsaw = (JigsawTemplate)template;
            Iterator<JigsawTemplate> iterator = jigsaw.getChildren().iterator();
            JigsawTemplate target = null;
            int i = 0;
            while (iterator.hasNext()) {
                JigsawTemplate child = iterator.next();
                if (!child.hasTag(VaultMod.id("objective_piece"))) continue;
                if (random.nextInt(++i) == 0) {
                    target = child;
                }
                iterator.remove();
            }
            double probability = 1.0;
            probability = CommonEvents.OBJECTIVE_PIECE_GENERATION.invoke(vault, probability).getProbability();
            if ((double)random.nextFloat() < probability && target != null) {
                jigsaw.getChildren().add(target);
            }
            for (JigsawTemplate child : jigsaw.getChildren()) {
                if (!child.hasTag(VaultMod.id("portal_piece"))) continue;
                ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
                if (region.m_123341_() == 0 && region.m_123343_() == 0) {
                    tags.add(ClassicPortalLogic.ENTRANCE);
                }
                tags.add(ClassicPortalLogic.EXIT);
                vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC).addPortal(child, settings, tags);
            }
        }
        return template;
    }

    public abstract Template getTemplate(PieceType var1, Vault var2, RegionPos var3, RandomSource var4, PlacementSettings var5);

    public abstract PieceType getType(Vault var1, RegionPos var2);

    public Template getStart(TemplatePool pool, Version version, RegionPos region, RandomSource random, Direction facing, PlacementSettings settings) {
        if (pool == null) {
            return EmptyTemplate.INSTANCE;
        }
        TemplateEntry entry = pool.getRandomFlat(version, random).orElse(null);
        if (entry == null) {
            return EmptyTemplate.INSTANCE;
        }
        Mirror mirror = random.nextBoolean() ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rotation = switch (facing) {
            case Direction.NORTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.NONE;
            default -> throw new UnsupportedOperationException("Cannot place start facing " + facing);
        };
        BlockPos offset = new BlockPos(13, 0, 26);
        BlockPos pos = region.toBlockPos().m_6630_(22);
        settings.addProcessors(new Processor[]{TileProcessor.translate((Vec3i)offset), TileProcessor.mirror(mirror, 23, 23, true), TileProcessor.rotate(rotation, 23, 23, true), TileProcessor.translate((Vec3i)pos), EntityProcessor.translate((Vec3i)offset), EntityProcessor.mirror(mirror, 23, 23, true), EntityProcessor.rotate(rotation, 23, 23, true), EntityProcessor.translate((Vec3i)pos)});
        return JigsawTemplate.of(version, entry, 10, random);
    }

    public Template getRoom(TemplatePool pool, Version version, RegionPos region, RandomSource random, PlacementSettings settings) {
        if (pool == null) {
            return EmptyTemplate.INSTANCE;
        }
        TemplateEntry entry = pool.getRandomFlat(version, random).orElse(null);
        if (entry == null) {
            return EmptyTemplate.INSTANCE;
        }
        Mirror mirror = random.nextBoolean() ? Mirror.NONE : Mirror.FRONT_BACK;
        Rotation rotation = (new Rotation[]{Rotation.NONE, Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180})[random.nextInt(4)];
        BlockPos pos = region.toBlockPos().m_6630_(region.getSizeX() > 47 ? 0 : 9);
        int offsetX = region.getSizeX() / 2;
        int offsetZ = region.getSizeZ() / 2;
        settings.addProcessors(new Processor[]{TileProcessor.mirror(mirror, offsetX, offsetZ, true), TileProcessor.rotate(rotation, offsetX, offsetZ, true), TileProcessor.translate((Vec3i)pos), EntityProcessor.mirror(mirror, offsetX, offsetZ, true), EntityProcessor.rotate(rotation, offsetX, offsetZ, true), EntityProcessor.translate((Vec3i)pos)});
        return JigsawTemplate.of(version, entry, 10, random);
    }

    public Template getTunnel(TemplatePool pool, Version version, RegionPos region, RandomSource random, Direction.Axis axis, PlacementSettings settings) {
        Rotation rotation;
        if (pool == null) {
            return EmptyTemplate.INSTANCE;
        }
        TemplateEntry entry = pool.getRandomFlat(version, random).orElse(null);
        if (entry == null) {
            return EmptyTemplate.INSTANCE;
        }
        int index = random.nextInt(4);
        Mirror mirror = (new Mirror[]{Mirror.NONE, Mirror.FRONT_BACK, Mirror.LEFT_RIGHT, Mirror.NONE})[index];
        Rotation rotation2 = rotation = index == 3 ? Rotation.CLOCKWISE_180 : Rotation.NONE;
        if (axis == Direction.Axis.X) {
            rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
        }
        BlockPos offset = new BlockPos(18, 0, 0);
        BlockPos pos = region.toBlockPos().m_6630_(27);
        settings.addProcessors(new Processor[]{TileProcessor.translate((Vec3i)offset), TileProcessor.mirror(mirror, 23, 23, true), TileProcessor.rotate(rotation, 23, 23, true), TileProcessor.translate((Vec3i)pos), EntityProcessor.translate((Vec3i)offset), EntityProcessor.mirror(mirror, 23, 23, true), EntityProcessor.rotate(rotation, 23, 23, true), EntityProcessor.translate((Vec3i)pos)});
        return JigsawTemplate.of(version, entry, 10, random);
    }

    public static enum PieceType {
        NONE,
        START,
        START_NORTH,
        START_SOUTH,
        START_WEST,
        START_EAST,
        ROOM,
        TUNNEL_X,
        TUNNEL_Z;


        public boolean isStart() {
            return this == START || this == START_NORTH || this == START_SOUTH || this == START_WEST || this == START_EAST;
        }

        public boolean isTunnel() {
            return this == TUNNEL_X || this == TUNNEL_Z;
        }

        public boolean connectsToTunnel() {
            return this.isStart() || this == ROOM;
        }

        public PieceType rotate(Rotation rotation) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> NONE;
                case START -> START;
                case START_NORTH -> PieceType.ofStart(rotation.m_55954_(Direction.NORTH));
                case START_SOUTH -> PieceType.ofStart(rotation.m_55954_(Direction.SOUTH));
                case START_WEST -> PieceType.ofStart(rotation.m_55954_(Direction.WEST));
                case START_EAST -> PieceType.ofStart(rotation.m_55954_(Direction.EAST));
                case ROOM -> ROOM;
                case TUNNEL_X -> PieceType.ofTunnel(rotation.m_55954_(Direction.WEST));
                case TUNNEL_Z -> PieceType.ofTunnel(rotation.m_55954_(Direction.NORTH));
            };
        }

        public static PieceType ofStart(Direction facing) {
            return switch (facing) {
                case Direction.NORTH -> START_NORTH;
                case Direction.SOUTH -> START_SOUTH;
                case Direction.WEST -> START_WEST;
                case Direction.EAST -> START_EAST;
                default -> throw new UnsupportedOperationException("Start cannot face " + facing);
            };
        }

        public static PieceType ofTunnel(Direction direction) {
            return PieceType.ofTunnel(direction.m_122434_());
        }

        public static PieceType ofTunnel(Direction.Axis axis) {
            return switch (axis) {
                case Direction.Axis.X -> TUNNEL_X;
                case Direction.Axis.Z -> TUNNEL_Z;
                default -> throw new UnsupportedOperationException("Tunnel cannot be aligned on " + axis);
            };
        }
    }
}

