/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.loot.generator;

import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.LootGenerationEvent;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.core.world.loot.LootTable;
import iskallia.vault.core.world.loot.generator.LootGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class LootTableGenerator
implements LootGenerator {
    protected final Version version;
    protected final LootTable table;
    public float itemQuantity;
    public Map<ItemPredicate, Float> itemQuantityOverrides = new HashMap<ItemPredicate, Float>();
    public Entity source;
    protected final List<ItemStack> items = new ArrayList<ItemStack>();

    public LootTableGenerator(Version version, LootTableKey table, float itemQuantity) {
        this(version, (LootTable)table.get(version), itemQuantity);
    }

    public LootTableGenerator(Version version, LootTable table, float itemQuantity) {
        this.version = version;
        this.table = table;
        this.itemQuantity = itemQuantity;
    }

    public LootTable getTable() {
        return this.table;
    }

    @Override
    public Iterator<ItemStack> getItems() {
        return this.items.iterator();
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    @Override
    public void generate(RandomSource random) {
        CommonEvents.LOOT_GENERATION.invoke(this, LootGenerationEvent.Phase.PRE);
        this.items.clear();
        if (this.table != null) {
            for (LootTable.Entry entry : this.table.getEntries()) {
                this.generateEntry(entry, random);
            }
        }
        CommonEvents.LOOT_GENERATION.invoke(this, LootGenerationEvent.Phase.POST);
    }

    protected void generateEntry(LootTable.Entry entry, RandomSource random) {
        int roll = entry.getRoll().get(random);
        float fRoll = (float)roll * (1.0f + this.itemQuantity);
        roll = (int)fRoll + (random.nextFloat() < fRoll - (float)roll ? 1 : 0);
        for (int i = 0; i < roll; ++i) {
            entry.getPool().getRandomFlat(this.version, random).map(e -> {
                OverSizedItemStack stack = e.getOverStack(random);
                double increase = 0.0;
                for (Map.Entry<ItemPredicate, Float> override : this.itemQuantityOverrides.entrySet()) {
                    if (!override.getKey().test(stack.overSizedStack())) continue;
                    increase += (double)override.getValue().floatValue();
                }
                int amount = 0;
                for (double fAmount = (double)stack.amount() * (1.0 + increase); fAmount > 0.0 && (double)random.nextFloat() < fAmount; fAmount -= 1.0) {
                    ++amount;
                }
                return stack.copyAmount(amount).splitByStackSize();
            }).ifPresent(this.items::addAll);
        }
    }
}

