/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.entity;

import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class MirrorEntityProcessor
extends EntityProcessor {
    public final Mirror mirror;
    public final int plane;
    public final boolean centered;
    private final int term;

    public MirrorEntityProcessor(Mirror mirror, int plane, boolean centered) {
        this.mirror = mirror;
        this.plane = plane;
        this.centered = centered;
        this.term = this.plane + this.plane - (this.centered ? 0 : 1);
    }

    public BlockPos transform(BlockPos pos) {
        return switch (this.mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> new BlockPos(this.term - pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            case Mirror.LEFT_RIGHT -> new BlockPos(pos.m_123341_(), pos.m_123342_(), this.term - pos.m_123343_());
            case Mirror.NONE -> pos;
        };
    }

    public Vec3 transform(Vec3 pos) {
        return switch (this.mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> new Vec3((double)this.term - pos.f_82479_ + 1.0, pos.f_82480_, pos.f_82481_);
            case Mirror.LEFT_RIGHT -> new Vec3(pos.f_82479_, pos.f_82480_, (double)this.term - pos.f_82481_ + 1.0);
            case Mirror.NONE -> pos;
        };
    }

    public float transformEntity(float yaw) {
        yaw = Mth.m_14177_((float)yaw);
        return switch (this.mirror) {
            case Mirror.FRONT_BACK -> -yaw;
            case Mirror.LEFT_RIGHT -> -yaw + 180.0f;
            default -> yaw;
        };
    }

    public Tuple<Float, Direction> transformHangingEntity(float yaw, Direction direction) {
        Rotation rotation = this.mirror.m_54846_(direction);
        if (direction.m_122434_() != Direction.Axis.Y) {
            direction = switch (rotation) {
                case Rotation.CLOCKWISE_180 -> direction.m_122424_();
                case Rotation.COUNTERCLOCKWISE_90 -> direction.m_122428_();
                case Rotation.CLOCKWISE_90 -> direction.m_122427_();
                default -> direction;
            };
        }
        yaw = Mth.m_14177_((float)yaw);
        yaw = switch (rotation) {
            case Rotation.CLOCKWISE_180 -> yaw + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> yaw + 90.0f;
            case Rotation.CLOCKWISE_90 -> yaw + 270.0f;
            default -> yaw;
        };
        return new Tuple((Object)Float.valueOf(yaw), (Object)direction);
    }

    @Override
    public PartialEntity process(PartialEntity entity, ProcessorContext context) {
        entity.setBlockPos(this.transform(entity.getBlockPos()));
        entity.setPos(this.transform(entity.getPos()));
        CompoundTag nbt = entity.getNbt().asWhole().orElse(null);
        if (nbt != null && nbt.m_128425_("Rotation", 5)) {
            ListTag rotation = nbt.m_128437_("Rotation", 5);
            float yaw = rotation.m_128775_(0);
            EntityType type = EntityType.m_20637_((CompoundTag)nbt).orElse(EntityType.f_20529_);
            if (type == EntityType.f_20462_ || type == EntityType.f_147033_) {
                Direction direction = Direction.m_122376_((int)nbt.m_128445_("Facing"));
                Tuple<Float, Direction> result = this.transformHangingEntity(yaw, direction);
                yaw = ((Float)result.m_14418_()).floatValue();
                direction = (Direction)result.m_14419_();
                nbt.m_128344_("Facing", (byte)direction.m_122411_());
            } else if (type == EntityType.f_20506_) {
                Direction direction = Direction.m_122407_((int)nbt.m_128445_("Facing"));
                Tuple<Float, Direction> result = this.transformHangingEntity(yaw, direction);
                yaw = ((Float)result.m_14418_()).floatValue();
                direction = (Direction)result.m_14419_();
                nbt.m_128344_("Facing", (byte)direction.m_122416_());
            } else {
                yaw = type == EntityType.f_20464_ ? ((Float)this.transformHangingEntity(yaw, Direction.SOUTH).m_14418_()).floatValue() : this.transformEntity(yaw);
            }
            rotation.set(0, (Tag)FloatTag.m_128566_((float)(yaw + rotation.m_128775_(0))));
        }
        return entity;
    }
}

