/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.entity;

import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class RotateEntityProcessor
extends EntityProcessor {
    public final Rotation rotation;
    public final int pivotX;
    public final int pivotZ;
    public final boolean centered;
    private final int termX;
    private final int termZ;

    public RotateEntityProcessor(Rotation rotation, int pivotX, int pivotZ, boolean centered) {
        this.rotation = rotation;
        this.pivotX = pivotX;
        this.pivotZ = pivotZ;
        this.centered = centered;
        switch (this.rotation) {
            case COUNTERCLOCKWISE_90: {
                this.termX = this.pivotX - this.pivotZ - (this.centered ? 0 : 1);
                this.termZ = this.pivotX + this.pivotZ;
                break;
            }
            case CLOCKWISE_90: {
                this.termX = this.pivotX + this.pivotZ;
                this.termZ = this.pivotZ - this.pivotX - (this.centered ? 0 : 1);
                break;
            }
            case CLOCKWISE_180: {
                this.termX = this.pivotX + this.pivotX - (this.centered ? 0 : 1);
                this.termZ = this.pivotZ + this.pivotZ - (this.centered ? 0 : 1);
                break;
            }
            default: {
                this.termX = 0;
                this.termZ = 0;
            }
        }
    }

    public BlockPos transform(BlockPos pos) {
        return switch (this.rotation) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(this.termX + pos.m_123343_(), pos.m_123342_(), this.termZ - pos.m_123341_());
            case Rotation.CLOCKWISE_90 -> new BlockPos(this.termX - pos.m_123343_(), pos.m_123342_(), this.termZ + pos.m_123341_());
            case Rotation.CLOCKWISE_180 -> new BlockPos(this.termX - pos.m_123341_(), pos.m_123342_(), this.termZ - pos.m_123343_());
            default -> pos;
        };
    }

    public Vec3 transform(Vec3 pos) {
        return switch (this.rotation) {
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3((double)this.termX + pos.f_82481_, pos.f_82480_, (double)this.termZ - pos.f_82479_ + 1.0);
            case Rotation.CLOCKWISE_90 -> new Vec3((double)this.termX - pos.f_82481_ + 1.0, pos.f_82480_, (double)this.termZ + pos.f_82479_);
            case Rotation.CLOCKWISE_180 -> new Vec3((double)this.termX - pos.f_82479_ + 1.0, pos.f_82480_, (double)this.termZ - pos.f_82481_ + 1.0);
            default -> pos;
        };
    }

    public float transformEntity(float yaw) {
        yaw = Mth.m_14177_((float)yaw);
        return switch (this.rotation) {
            case Rotation.CLOCKWISE_180 -> yaw + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> yaw + 270.0f;
            case Rotation.CLOCKWISE_90 -> yaw + 90.0f;
            default -> yaw;
        };
    }

    public Tuple<Float, Direction> transformHangingEntity(float yaw, Direction direction) {
        if (direction.m_122434_() != Direction.Axis.Y) {
            direction = switch (this.rotation) {
                case Rotation.CLOCKWISE_180 -> direction.m_122424_();
                case Rotation.COUNTERCLOCKWISE_90 -> direction.m_122428_();
                case Rotation.CLOCKWISE_90 -> direction.m_122427_();
                default -> direction;
            };
        }
        yaw = Mth.m_14177_((float)yaw);
        yaw = switch (this.rotation) {
            case Rotation.CLOCKWISE_180 -> yaw + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> yaw + 90.0f;
            case Rotation.CLOCKWISE_90 -> yaw + 270.0f;
            default -> yaw;
        };
        return new Tuple((Object)Float.valueOf(yaw), (Object)direction);
    }

    @Override
    public PartialEntity process(PartialEntity entity, ProcessorContext context) {
        entity.setBlockPos(this.transform(entity.getBlockPos()));
        entity.setPos(this.transform(entity.getPos()));
        CompoundTag nbt = entity.getNbt().asWhole().orElse(null);
        if (nbt != null && nbt.m_128425_("Rotation", 5)) {
            ListTag rotation = nbt.m_128437_("Rotation", 5);
            float yaw = rotation.m_128775_(0);
            EntityType type = EntityType.m_20637_((CompoundTag)nbt).orElse(EntityType.f_20529_);
            if (type == EntityType.f_20462_ || type == EntityType.f_147033_) {
                Direction direction = Direction.m_122376_((int)nbt.m_128445_("Facing"));
                Tuple<Float, Direction> result = this.transformHangingEntity(yaw, direction);
                yaw = ((Float)result.m_14418_()).floatValue();
                direction = (Direction)result.m_14419_();
                nbt.m_128344_("Facing", (byte)direction.m_122411_());
            } else if (type == EntityType.f_20506_) {
                Direction direction = Direction.m_122407_((int)nbt.m_128445_("Facing"));
                Tuple<Float, Direction> result = this.transformHangingEntity(yaw, direction);
                yaw = ((Float)result.m_14418_()).floatValue();
                direction = (Direction)result.m_14419_();
                nbt.m_128344_("Facing", (byte)direction.m_122416_());
            } else {
                yaw = type == EntityType.f_20464_ ? ((Float)this.transformHangingEntity(yaw, Direction.SOUTH).m_14418_()).floatValue() : this.transformEntity(yaw);
            }
            rotation.set(0, (Tag)FloatTag.m_128566_((float)(yaw - rotation.m_128775_(0))));
        }
        return entity;
    }
}

