/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.Version;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import java.util.Iterator;
import net.minecraft.resources.ResourceLocation;

public class ReferenceTileProcessor
extends TileProcessor {
    private final ResourceLocation id;

    public ReferenceTileProcessor(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public PartialTile process(PartialTile value, ProcessorContext context) {
        TileProcessor child;
        Version version = context.getVault() == null ? Version.latest() : context.getVault().get(Vault.VERSION);
        Palette palette = (Palette)VaultRegistry.PALETTE.getKey(this.id).get(version);
        Iterator<TileProcessor> iterator = palette.getTileProcessors().iterator();
        while (iterator.hasNext() && (value = (child = iterator.next()).process(value, context)) != null) {
        }
        return value;
    }
}

