/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TargetTileProcessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class SpawnerElementTileProcessor
extends TargetTileProcessor<SpawnerElementTileProcessor> {
    protected EntityPredicate element;
    protected final WeightedList<PartialEntity> output = new WeightedList();

    public WeightedList<PartialEntity> getOutput() {
        return this.output;
    }

    public SpawnerElementTileProcessor setElement(EntityPredicate element) {
        this.element = element;
        return this;
    }

    public SpawnerElementTileProcessor into(PartialEntity output, int weight) {
        this.output.put(output, weight);
        return this;
    }

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        tile.getEntity().asWhole().ifPresent(tag -> {
            if (!tag.m_128425_("Inventory", 10)) {
                return;
            }
            if (!(tag = tag.m_128469_("Inventory")).m_128425_("Stacks", 9)) {
                return;
            }
            ListTag stacks = tag.m_128437_("Stacks", 10);
            for (int i = 0; i < stacks.size(); ++i) {
                CompoundTag stack = stacks.m_128728_(i);
                CompoundTag nbt = stack.m_128469_("tag").m_128469_("EntityTag");
                PartialEntity entity = PartialEntity.of(null, null, PartialCompoundNbt.of(nbt));
                if (!this.element.test(entity)) continue;
                this.output.getRandom(context.getRandom(tile.getPos())).ifPresent(other -> {
                    PartialCompoundNbt result = PartialCompoundNbt.of(nbt);
                    other.getNbt().fillInto(result);
                    result.asWhole().ifPresent(compoundTag -> {
                        CompoundTag wrapped = new CompoundTag();
                        wrapped.m_128365_("EntityTag", (Tag)compoundTag);
                        stack.m_128365_("tag", (Tag)wrapped);
                    });
                });
            }
        });
        return tile;
    }
}

