/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.BoundedTileProcessor;
import iskallia.vault.core.world.processor.tile.IdentityTileProcessor;
import iskallia.vault.core.world.processor.tile.JigsawTileProcessor;
import iskallia.vault.core.world.processor.tile.MirrorTileProcessor;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.StructureVoidTileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import iskallia.vault.core.world.processor.tile.WeightedTileProcessor;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public abstract class TileProcessor
implements Processor<PartialTile> {
    public static TileProcessor of(final Processor<PartialTile> processor) {
        return new TileProcessor(){

            @Override
            public PartialTile process(PartialTile value, ProcessorContext context) {
                return processor.process(value, context);
            }
        };
    }

    public static IdentityTileProcessor ofIdentity() {
        return new IdentityTileProcessor();
    }

    public static WeightedTileProcessor ofWeighted() {
        return new WeightedTileProcessor();
    }

    public static MirrorTileProcessor mirror(Mirror mirror, int plane, boolean centered) {
        return new MirrorTileProcessor(mirror, plane, centered);
    }

    public static MirrorTileProcessor mirror(Mirror mirror, int planeX, int planeZ, boolean centered) {
        int plane = switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> planeX;
            case Mirror.LEFT_RIGHT -> planeZ;
            case Mirror.NONE -> 0;
        };
        return TileProcessor.mirror(mirror, plane, centered);
    }

    public static MirrorTileProcessor mirror(Mirror mirror, Vec3i planes, boolean centered) {
        return TileProcessor.mirror(mirror, planes.m_123341_(), planes.m_123343_(), centered);
    }

    public static MirrorTileProcessor mirrorRandomly(RandomSource random, int plane, boolean centered) {
        Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
        return TileProcessor.mirror(mirror, plane, centered);
    }

    public static MirrorTileProcessor mirrorRandomly(RandomSource random, int planeX, int planeZ, boolean centered) {
        Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
        return TileProcessor.mirror(mirror, planeX, planeZ, centered);
    }

    public static MirrorTileProcessor mirrorRandomly(RandomSource random, Vec3i planes, boolean centered) {
        return TileProcessor.mirrorRandomly(random, planes.m_123341_(), planes.m_123343_(), centered);
    }

    public static RotateTileProcessor rotate(Rotation rotation, int pivotX, int pivotZ, boolean centered) {
        return new RotateTileProcessor(rotation, pivotX, pivotZ, centered);
    }

    public static RotateTileProcessor rotate(Rotation rotation, Vec3i pivot, boolean centered) {
        return TileProcessor.rotate(rotation, pivot.m_123341_(), pivot.m_123343_(), centered);
    }

    public static RotateTileProcessor rotateRandomly(RandomSource random, int pivotX, int pivotZ, boolean centered) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        return TileProcessor.rotate(rotation, pivotX, pivotZ, centered);
    }

    public static RotateTileProcessor rotateRandomly(RandomSource random, Vec3i pivot, boolean centered) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        return TileProcessor.rotate(rotation, pivot.m_123341_(), pivot.m_123343_(), centered);
    }

    public static TranslateTileProcessor translate(int offsetX, int offsetY, int offsetZ) {
        return new TranslateTileProcessor(offsetX, offsetY, offsetZ);
    }

    public static TranslateTileProcessor translate(Vec3i offset) {
        return new TranslateTileProcessor(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    public static BoundedTileProcessor bound(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new BoundedTileProcessor(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static BoundedTileProcessor bound(BoundingBox box) {
        return TileProcessor.bound(box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
    }

    public static BoundedTileProcessor bound(ChunkPos chunkPos, int minY, int maxY) {
        return new BoundedTileProcessor(chunkPos.f_45578_ * 16, minY, chunkPos.f_45579_ * 16, chunkPos.f_45578_ * 16 + 15, maxY, chunkPos.f_45579_ * 16 + 15);
    }

    public static JigsawTileProcessor ofJigsaw() {
        return new JigsawTileProcessor();
    }

    public static StructureVoidTileProcessor ofStructureVoid() {
        return new StructureVoidTileProcessor();
    }
}

