/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PlaceholderGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.BernoulliWeightedTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.init.ModBlocks;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

public class VaultLootTileProcessor
extends TileProcessor {
    public PlaceholderBlock.Type target;
    public Map<Integer, TileProcessor> levels = new LinkedHashMap<Integer, TileProcessor>();

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        if (!tile.getState().is(ModBlocks.PLACEHOLDER)) {
            return tile;
        }
        if (tile.getState().get(PlaceholderBlock.TYPE) != this.target) {
            return tile;
        }
        Direction facing = (Direction)tile.getState().get(PlaceholderBlock.FACING);
        if (facing != null && facing.m_122434_() != Direction.Axis.Y) {
            tile.getState().set(BlockStateProperties.f_61374_, facing);
        } else {
            Direction randomFacing = Direction.m_122407_((int)context.getRandom(tile.getPos()).nextInt(4));
            tile.getState().set(BlockStateProperties.f_61374_, randomFacing);
        }
        CommonEvents.PLACEHOLDER_PROCESSING.invoke(tile, context);
        Processor processor = null;
        int level = context.getVault() == null ? 0 : context.getVault().get(Vault.LEVEL).get();
        for (Map.Entry<Integer, TileProcessor> entry : this.levels.entrySet()) {
            if (entry.getKey() > level) break;
            processor = entry.getValue();
        }
        if (processor instanceof BernoulliWeightedTileProcessor) {
            BernoulliWeightedTileProcessor bernoulli = (BernoulliWeightedTileProcessor)processor;
            PlaceholderGenerationEvent.Data result = CommonEvents.PLACEHOLDER_GENERATION.invoke(context.getVault(), this, tile, bernoulli.probability, bernoulli.success, bernoulli.failure);
            return bernoulli.process(tile, result.getProbability(), context);
        }
        return processor == null ? tile : processor.process(tile, context);
    }
}

