/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.roll;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.core.random.RandomSource;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public interface FloatRoll
extends INBTSerializable<CompoundTag> {
    public float get(RandomSource var1);

    public float getMin();

    public float getMax();

    public JsonObject serializeJson();

    public void deserializeJson(JsonObject var1);

    public static Constant ofConstant(float count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(float min, float max) {
        return new Uniform(min, max);
    }

    public static FloatRoll fromNBT(CompoundTag nbt) {
        FloatRoll roll;
        switch (nbt.m_128461_("type")) {
            case "constant": {
                FloatRoll floatRoll = new Constant();
                break;
            }
            case "uniform": {
                FloatRoll floatRoll = new Uniform();
                break;
            }
            default: {
                FloatRoll floatRoll = roll = null;
            }
        }
        if (roll != null) {
            roll.deserializeNBT((Tag)nbt);
        }
        return roll;
    }

    public static FloatRoll fromJson(JsonObject object) {
        FloatRoll roll;
        if (!object.has("type")) {
            v0 = null;
        } else {
            switch (object.get("type").getAsString()) {
                case "constant": {
                    v0 = new Constant();
                    break;
                }
                case "uniform": {
                    v0 = new Uniform();
                    break;
                }
                default: {
                    v0 = roll = null;
                }
            }
        }
        if (roll != null) {
            roll.deserializeJson(object);
        }
        return roll;
    }

    public static class Constant
    implements FloatRoll {
        private float count;

        protected Constant() {
        }

        protected Constant(float count) {
            this.count = count;
        }

        public float getCount() {
            return this.count;
        }

        @Override
        public float get(RandomSource random) {
            return this.count;
        }

        @Override
        public float getMin() {
            return this.count;
        }

        @Override
        public float getMax() {
            return this.count;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("type", "constant");
            nbt.m_128350_("count", this.count);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.count = nbt.m_128457_("count");
        }

        @Override
        public JsonObject serializeJson() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "constant");
            object.addProperty("count", (Number)Float.valueOf(this.count));
            return object;
        }

        @Override
        public void deserializeJson(JsonObject object) {
            this.count = object.get("count").getAsFloat();
        }
    }

    public static class Uniform
    implements FloatRoll {
        private float min;
        private float max;

        protected Uniform() {
        }

        protected Uniform(float min, float max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public float getMin() {
            return this.min;
        }

        @Override
        public float getMax() {
            return this.max;
        }

        @Override
        public float get(RandomSource random) {
            return random.nextFloat(this.min, this.max);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("type", "uniform");
            nbt.m_128350_("min", this.min);
            nbt.m_128350_("max", this.max);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.min = nbt.m_128457_("min");
            this.max = nbt.m_128457_("max");
        }

        @Override
        public JsonObject serializeJson() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "uniform");
            object.addProperty("min", (Number)Float.valueOf(this.min));
            object.addProperty("max", (Number)Float.valueOf(this.max));
            return object;
        }

        @Override
        public void deserializeJson(JsonObject object) {
            this.min = object.get("min").getAsFloat();
            this.max = object.get("max").getAsFloat();
        }
    }

    public static class Adapter
    implements JsonSerializer<FloatRoll>,
    JsonDeserializer<FloatRoll> {
        public static final Adapter INSTANCE = new Adapter();

        public FloatRoll deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String type;
            JsonObject object = json.getAsJsonObject();
            switch (type = object.get("type").getAsString()) {
                case "constant": {
                    return FloatRoll.ofConstant(object.get("count").getAsFloat());
                }
                case "uniform": {
                    return FloatRoll.ofUniform(object.get("min").getAsFloat(), object.get("max").getAsFloat());
                }
            }
            return null;
        }

        public JsonElement serialize(FloatRoll value, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (value instanceof Constant) {
                Constant constant = (Constant)value;
                object.addProperty("type", "constant");
                object.addProperty("count", (Number)Float.valueOf(constant.getCount()));
            } else if (value instanceof Uniform) {
                Uniform uniform = (Uniform)value;
                object.addProperty("type", "uniform");
                object.addProperty("min", (Number)Float.valueOf(uniform.getMin()));
                object.addProperty("max", (Number)Float.valueOf(uniform.getMax()));
            }
            return object;
        }
    }
}

