/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.roll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.item.crystal.data.serializable.ISerializable;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public interface IntRoll
extends ISerializable<CompoundTag, JsonObject> {
    public int get(RandomSource var1);

    public static Constant ofConstant(int count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(int min, int max) {
        return new Uniform(min, max);
    }

    public static int getMin(IntRoll roll) {
        if (roll instanceof Constant) {
            Constant constant = (Constant)roll;
            return constant.getCount();
        }
        if (roll instanceof Uniform) {
            Uniform uniform = (Uniform)roll;
            return uniform.getMin();
        }
        throw new UnsupportedOperationException();
    }

    public static int getMax(IntRoll roll) {
        if (roll instanceof Constant) {
            Constant constant = (Constant)roll;
            return constant.getCount();
        }
        if (roll instanceof Uniform) {
            Uniform uniform = (Uniform)roll;
            return uniform.getMax();
        }
        throw new UnsupportedOperationException();
    }

    public static class Constant
    implements IntRoll {
        private int count;

        protected Constant() {
        }

        protected Constant(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int get(RandomSource random) {
            return this.count;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("count")).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.count).ifPresent(tag -> json.add("count", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("count")).ifPresent(value -> {
                this.count = value;
            });
        }
    }

    public static class Uniform
    implements IntRoll {
        private int min;
        private int max;

        protected Uniform() {
        }

        protected Uniform(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        public int get(RandomSource random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<IntRoll> {
        public Adapter() {
            super("type", true);
            this.register("constant", Constant.class, Constant::new);
            this.register("uniform", Uniform.class, Uniform::new);
        }

        @Override
        @Nullable
        protected IntRoll readSuppliedNbt(Tag nbt) {
            Optional result;
            if ((nbt instanceof NumericTag || nbt instanceof StringTag) && (result = Adapters.INT.readNbt(nbt)).isPresent()) {
                return IntRoll.ofConstant((Integer)result.get());
            }
            return (IntRoll)super.readSuppliedNbt(nbt);
        }

        @Override
        @Nullable
        protected IntRoll readSuppliedJson(JsonElement json) {
            Optional result;
            JsonPrimitive primitive;
            if (json instanceof JsonPrimitive && ((primitive = (JsonPrimitive)json).isNumber() || primitive.isString()) && (result = Adapters.INT.readJson(json)).isPresent()) {
                return IntRoll.ofConstant((Integer)result.get());
            }
            return (IntRoll)super.readSuppliedJson(json);
        }
    }
}

