/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.iterator.FlatteningIterator;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.generator.JigsawData;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.core.world.template.data.TemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;

public class JigsawTemplate
extends Template {
    private Template root;
    private List<JigsawTemplate> children = new ArrayList<JigsawTemplate>();
    private Consumer<PlacementSettings> configurator = settings -> {};

    protected JigsawTemplate(Template root) {
        this.root = root;
    }

    @Override
    public Iterator<ResourceLocation> getTags() {
        return this.root.getTags();
    }

    @Override
    public void addTag(ResourceLocation tag) {
        this.root.addTag(tag);
    }

    @Override
    public boolean hasTag(ResourceLocation tag) {
        return this.root.hasTag(tag);
    }

    public Consumer<PlacementSettings> getConfigurator() {
        return this.configurator;
    }

    public List<JigsawTemplate> getChildren() {
        return this.children;
    }

    public void setChildren(List<JigsawTemplate> children) {
        this.children = children;
    }

    public static JigsawTemplate of(Version version, Template root, Collection<PaletteKey> palettes, int depth, RandomSource random) {
        JigsawTemplate template = new JigsawTemplate(root);
        template.computeChildren(version, depth, random);
        template.configurator = settings -> {
            settings.addProcessor(TileProcessor.ofJigsaw());
            settings.addProcessor(TileProcessor.ofStructureVoid());
            for (PaletteKey palette : palettes) {
                settings.addProcessor((Palette)palette.get(version));
            }
        };
        return template;
    }

    public static JigsawTemplate of(Version version, TemplateEntry root, int depth, RandomSource random) {
        JigsawTemplate template = new JigsawTemplate((Template)root.getTemplate().get(version));
        template.computeChildren(version, depth, random);
        template.configurator = settings -> {
            settings.addProcessor(TileProcessor.ofJigsaw());
            settings.addProcessor(TileProcessor.ofStructureVoid());
            for (PaletteKey palette : root.getPalettes()) {
                settings.addProcessor((Palette)palette.get(version));
            }
        };
        return template;
    }

    protected JigsawTemplate computeChildren(Version version, int depth, RandomSource random) {
        if (depth < 0) {
            return this;
        }
        this.root.getTiles(Template.JIGSAWS).forEachRemaining(start -> {
            JigsawData data1 = new JigsawData((PartialTile)start);
            TemplatePoolKey pool = VaultRegistry.TEMPLATE_POOL.getKey(data1.getPool());
            if (pool == null) {
                return;
            }
            TemplateEntry entry = ((TemplatePool)pool.get(version)).getRandomFlat(version, random).orElse(null);
            if (entry == null || entry.getTemplate() == null) {
                return;
            }
            Template childTemplate = (Template)entry.getTemplate().get(version);
            JigsawData data2 = null;
            Iterator<PartialTile> iterator = childTemplate.getTiles(Template.JIGSAWS);
            int size = 0;
            while (iterator.hasNext()) {
                PartialTile tile = iterator.next();
                JigsawData other = new JigsawData(tile);
                if (!data1.getTarget().equals((Object)other.getName())) {
                    return;
                }
                if (data1.getFacing().m_122434_().m_122479_() != other.getFacing().m_122434_().m_122479_()) {
                    return;
                }
                if (data1.getFacing().m_122434_().m_122479_() && data1.getSide() != other.getSide()) {
                    return;
                }
                if (random.nextInt(size++ + 1) != 0) continue;
                data2 = other;
            }
            if (data2 == null) {
                return;
            }
            BlockPos target = data2.getPos();
            BlockPos offset = start.getPos().m_141950_((Vec3i)target).m_142300_(data1.getFacing());
            Rotation rotation = this.getRotation(data2, data1, random);
            JigsawTemplate child = new JigsawTemplate(childTemplate);
            child.configurator = settings -> {
                int index = 0;
                settings.getTileProcessors().add(index++, TileProcessor.rotate(rotation, (Vec3i)target, true));
                settings.getTileProcessors().add(index++, TileProcessor.translate((Vec3i)offset));
                settings.getTileProcessors().add(index++, TileProcessor.ofJigsaw());
                for (PaletteKey palette : entry.getPalettes()) {
                    for (TileProcessor tileProcessor : ((Palette)palette.get(version)).getTileProcessors()) {
                        settings.getTileProcessors().add(index++, tileProcessor);
                    }
                    for (EntityProcessor entityProcessor : ((Palette)palette.get(version)).getEntityProcessors()) {
                        settings.getEntityProcessors().add(index++, entityProcessor);
                    }
                }
            };
            child.computeChildren(version, depth - 1, random);
            this.children.add(child);
        });
        return this;
    }

    @Override
    public Iterator<PartialTile> getTiles(TilePredicate filter, PlacementSettings settings) {
        PlacementSettings copy = settings.copy();
        this.configurator.accept(copy);
        ArrayList<Iterator<PartialTile>> iterators = new ArrayList<Iterator<PartialTile>>();
        iterators.add(this.root.getTiles(filter, copy));
        this.children.forEach(child -> iterators.add(child.getTiles(filter, copy)));
        return new FlatteningIterator<PartialTile>(iterators.iterator());
    }

    @Override
    public Iterator<PartialEntity> getEntities(EntityPredicate filter, PlacementSettings settings) {
        PlacementSettings copy = settings.copy();
        this.configurator.accept(copy);
        ArrayList<Iterator<PartialEntity>> iterators = new ArrayList<Iterator<PartialEntity>>();
        iterators.add(this.root.getEntities(filter, copy));
        this.children.forEach(child -> iterators.add(child.getEntities(filter, copy)));
        return new FlatteningIterator<PartialEntity>(iterators.iterator());
    }

    private Rotation getRotation(JigsawData from, JigsawData to, RandomSource random) {
        if (from.getFacing().m_122434_() == Direction.Axis.Y) {
            if (from.getJoint() == JigsawBlockEntity.JointType.ROLLABLE || to.getJoint() == JigsawBlockEntity.JointType.ROLLABLE) {
                return Rotation.values()[random.nextInt(4)];
            }
            return this.getRotation(from.getSide(), to.getSide());
        }
        return this.getRotation(from.getFacing(), to.getFacing().m_122424_());
    }

    private Rotation getRotation(Direction from, Direction to) {
        return switch (from) {
            case Direction.NORTH -> {
                switch (to) {
                    case NORTH: {
                        yield Rotation.NONE;
                    }
                    case SOUTH: {
                        yield Rotation.CLOCKWISE_180;
                    }
                    case WEST: {
                        yield Rotation.COUNTERCLOCKWISE_90;
                    }
                    case EAST: {
                        yield Rotation.CLOCKWISE_90;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case Direction.SOUTH -> {
                switch (to) {
                    case NORTH: {
                        yield Rotation.CLOCKWISE_180;
                    }
                    case SOUTH: {
                        yield Rotation.NONE;
                    }
                    case WEST: {
                        yield Rotation.CLOCKWISE_90;
                    }
                    case EAST: {
                        yield Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case Direction.WEST -> {
                switch (to) {
                    case NORTH: {
                        yield Rotation.CLOCKWISE_90;
                    }
                    case SOUTH: {
                        yield Rotation.COUNTERCLOCKWISE_90;
                    }
                    case WEST: {
                        yield Rotation.NONE;
                    }
                    case EAST: {
                        yield Rotation.CLOCKWISE_180;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case Direction.EAST -> {
                switch (to) {
                    case NORTH: {
                        yield Rotation.COUNTERCLOCKWISE_90;
                    }
                    case SOUTH: {
                        yield Rotation.CLOCKWISE_90;
                    }
                    case WEST: {
                        yield Rotation.CLOCKWISE_180;
                    }
                    case EAST: {
                        yield Rotation.NONE;
                    }
                }
                throw new UnsupportedOperationException();
            }
            default -> throw new UnsupportedOperationException();
        };
    }
}

