/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.TemplateKey;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.template.data.TemplateEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class DirectTemplateEntry
implements TemplateEntry {
    protected ResourceLocation template;
    protected List<ResourceLocation> palettes;

    public DirectTemplateEntry() {
        this(null, new ArrayList<ResourceLocation>());
    }

    public DirectTemplateEntry(ResourceLocation template) {
        this.template = template;
        this.palettes = new ArrayList<ResourceLocation>();
    }

    public DirectTemplateEntry(ResourceLocation template, List<ResourceLocation> palettes) {
        this.template = template;
        this.palettes = new ArrayList<ResourceLocation>(palettes);
    }

    @Override
    public TemplateKey getTemplate() {
        return VaultRegistry.TEMPLATE.getKey(this.template);
    }

    @Override
    public Iterable<PaletteKey> getPalettes() {
        return () -> new MappingIterator<ResourceLocation, PaletteKey>(this.palettes.iterator(), id -> VaultRegistry.PALETTE.getKey((ResourceLocation)id));
    }

    @Override
    public void addPalettes(Iterable<ResourceLocation> palettes) {
        for (ResourceLocation palette : palettes) {
            this.palettes.add(palette);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.IDENTIFIER.writeBits(this.template, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.palettes.size(), buffer);
        for (ResourceLocation palette : this.palettes) {
            Adapters.IDENTIFIER.writeBits(palette, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.template = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
        int size = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.palettes = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            this.palettes.add(Adapters.IDENTIFIER.readBits(buffer).orElseThrow());
        }
    }

    @Override
    public Optional<Tag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.IDENTIFIER.writeNbt(this.template).ifPresent(value -> nbt.m_128365_("template", value));
        ListTag list = new ListTag();
        for (ResourceLocation palette : this.palettes) {
            Adapters.IDENTIFIER.writeNbt(palette).ifPresent(arg_0 -> list.add(arg_0));
        }
        nbt.m_128365_("palettes", (Tag)list);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(Tag nbt) {
        if (!(nbt instanceof CompoundTag)) {
            return;
        }
        CompoundTag compound = (CompoundTag)nbt;
        Adapters.IDENTIFIER.readNbt(compound.m_128423_("template")).ifPresent(value -> {
            this.template = value;
        });
        if (!compound.m_128441_("palettes")) {
            return;
        }
        ListTag list = compound.m_128437_("palettes", 8);
        this.palettes = new ArrayList<ResourceLocation>();
        for (Tag tag : list) {
            Adapters.IDENTIFIER.readNbt(tag).ifPresent(this.palettes::add);
        }
    }

    @Override
    public Optional<JsonElement> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.IDENTIFIER.writeJson(this.template).ifPresent(element -> json.add("template", element));
        JsonArray array = new JsonArray();
        for (ResourceLocation palette : this.palettes) {
            Adapters.IDENTIFIER.writeJson(palette).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0));
        }
        json.add("palettes", (JsonElement)array);
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonElement json) {
        if (!(json instanceof JsonObject)) {
            return;
        }
        JsonObject object = (JsonObject)json;
        Adapters.IDENTIFIER.readJson(object.get("template")).ifPresent(value -> {
            this.template = value;
        });
        if (!object.has("palettes")) {
            return;
        }
        JsonArray array = object.getAsJsonArray("palettes");
        if (array == null) {
            return;
        }
        this.palettes = new ArrayList<ResourceLocation>();
        for (JsonElement element : array) {
            Adapters.IDENTIFIER.readJson(element).ifPresent(this.palettes::add);
        }
    }

    @Override
    public TemplateEntry flatten(Version version, RandomSource random) {
        return this.copy();
    }

    @Override
    public boolean validate() {
        return VaultRegistry.TEMPLATE.getKey(this.template) != null;
    }

    @Override
    public TemplateEntry copy() {
        return new DirectTemplateEntry(this.template, new ArrayList<ResourceLocation>(this.palettes));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("template=");
        sb.append(this.template.toString());
        sb.append(",palettes=[");
        for (ResourceLocation palette : this.palettes) {
            sb.append(palette).append(',');
        }
        sb.append("]}");
        return sb.toString();
    }
}

