/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.discoverylogic.goal;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.DiscoveryGoalsManager;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.discoverylogic.goal.base.InVaultDiscoveryGoal;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class VaultMobKillGoal
extends InVaultDiscoveryGoal<VaultMobKillGoal> {
    protected List<Predicate<LivingDeathEvent>> predicates = new LinkedList<Predicate<LivingDeathEvent>>();

    public VaultMobKillGoal(int targetProgress) {
        super(targetProgress);
    }

    public VaultMobKillGoal withPredicate(Predicate<LivingDeathEvent> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    public VaultMobKillGoal withKillerPredicate(Predicate<ServerPlayer> predicate) {
        this.predicates.add(e -> {
            Entity patt1103$temp = e.getSource().m_7639_();
            if (patt1103$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt1103$temp;
                return predicate.test(player);
            }
            return false;
        });
        return this;
    }

    @Override
    public void initServer(DiscoveryGoalsManager manager, VirtualWorld world, Vault vault) {
        CommonEvents.ENTITY_DEATH.register(manager, event -> {
            Entity patt1482$temp = event.getSource().m_7639_();
            if (!(patt1482$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1482$temp;
            if (player.m_183503_() != world) {
                return;
            }
            if (!this.predicates.stream().allMatch(p -> p.test(event))) {
                return;
            }
            this.progress(player, 1.0f);
        });
    }
}

