/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dynamodel.model.item.shield;

import iskallia.vault.VaultMod;
import iskallia.vault.dynamodel.model.item.shield.ShieldModel;
import iskallia.vault.util.calc.BlockChanceHelper;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowahShieldModel
extends ShieldModel {
    protected ResourceLocation eggeModelId;
    protected ResourceLocation eggBlockingModelId;

    public FlowahShieldModel(ResourceLocation id, ResourceLocation eggModelId, String displayName) {
        super(id, displayName);
        this.eggeModelId = eggModelId;
        this.eggBlockingModelId = FlowahShieldModel.appendToId(eggModelId, "_blocking");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Set<ModelResourceLocation> getAssociatedModelLocations() {
        Set<ModelResourceLocation> associatedModelLocations = super.getAssociatedModelLocations();
        associatedModelLocations.add(new ModelResourceLocation(this.eggeModelId, "inventory"));
        associatedModelLocations.add(new ModelResourceLocation(this.eggBlockingModelId, "inventory"));
        return associatedModelLocations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, ResourceLocation> resolveTextures(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        Map<String, ResourceLocation> resolveTextures = super.resolveTextures(resourceManager, resourceLocation);
        resolveTextures.put("egg", VaultMod.id("item/gear/shield/fried_egg"));
        return resolveTextures;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation resolveBakedIcon(@NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        String[] words = stack.m_41611_().getString().toLowerCase().split(" +");
        if (Stream.of(words).anyMatch(word -> word.contains("egg"))) {
            LocalPlayer player;
            if (entity instanceof LocalPlayer && BlockChanceHelper.isPlayerBlocking((Player)(player = (LocalPlayer)entity))) {
                return this.eggBlockingModelId;
            }
            return this.eggeModelId;
        }
        return super.resolveBakedIcon(stack, world, entity, seed);
    }
}

