/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.easteregg;

import iskallia.vault.VaultMod;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.util.AdvancementHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GrasshopperNinja {
    public static void achieve(ServerPlayer playerEntity) {
        AdvancementHelper.grantCriterion(playerEntity, VaultMod.id("main/grasshopper_ninja"), "hopped");
    }

    public static boolean isGrasshopperShape(Player playerEntity) {
        return ModDynamicModels.Armor.FAIRY.getPieces().entrySet().stream().allMatch(entry -> {
            EquipmentSlot equipmentSlot = (EquipmentSlot)entry.getKey();
            ArmorPieceModel pieceModel = (ArmorPieceModel)entry.getValue();
            ItemStack equipmentStack = (ItemStack)playerEntity.m_150109_().f_35975_.get(GrasshopperNinja.equipmentSlotToInventoryIndex(equipmentSlot));
            Item patt1253$temp = equipmentStack.m_41720_();
            if (!(patt1253$temp instanceof VaultArmorItem)) {
                return false;
            }
            VaultArmorItem vaultArmorItem = (VaultArmorItem)patt1253$temp;
            VaultGearData gearData = VaultGearData.read(equipmentStack);
            ResourceLocation modelId = gearData.getFirstValue(ModGearAttributes.GEAR_MODEL).orElse(null);
            if (modelId == null) {
                return false;
            }
            if (!pieceModel.getId().equals((Object)modelId)) {
                return false;
            }
            Integer gearColor = gearData.getFirstValue(ModGearAttributes.GEAR_COLOR).orElse(vaultArmorItem.m_41121_(equipmentStack));
            return GrasshopperNinja.isGrasshopperGreen(gearColor);
        });
    }

    private static int equipmentSlotToInventoryIndex(EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> 3;
            case EquipmentSlot.CHEST -> 2;
            case EquipmentSlot.LEGS -> 1;
            case EquipmentSlot.FEET -> 0;
            default -> -1;
        };
    }

    public static boolean isGrasshopperGreen(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float grasshopperGreenR = 0.58431375f;
        float dr = red - grasshopperGreenR;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float grasshopperGreenG = 0.7607843f;
        float dg = green - grasshopperGreenG;
        float blue = (float)(color & 0xFF) / 255.0f;
        float grasshopperGreenB = 0.40784314f;
        float db = blue - grasshopperGreenB;
        float distance = (float)(Math.sqrt(dr * dr + dg * dg + db * db) / 1.73205080757);
        return (double)distance < 0.35;
    }
}

