/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.easteregg;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.AdvancementHelper;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Witchskall {
    public static final float WITCHSKALL_CHANCE = 0.001f;
    public static final int WITCHSKALLIFICATION_TICKS = 100;
    public static EntityDataAccessor<Integer> WITCHSKALL_TICKS;
    public static EntityDataAccessor<Boolean> IS_WITCHSKALL;

    public static int getWitchskallificationTicks(Witch witchEntity) {
        return (Integer)witchEntity.m_20088_().m_135370_(WITCHSKALL_TICKS);
    }

    public static boolean isWitchskall(Witch witchEntity) {
        return (Boolean)witchEntity.m_20088_().m_135370_(IS_WITCHSKALL);
    }

    public static int setWitchskallificationTicks(Witch witchEntity, int ticks) {
        witchEntity.m_20088_().m_135381_(WITCHSKALL_TICKS, (Object)ticks);
        return ticks;
    }

    public static void witchskallificate(Witch witchEntity) {
        Witchskall.setWitchskallificationTicks(witchEntity, 0);
        witchEntity.m_20088_().m_135381_(IS_WITCHSKALL, (Object)true);
        witchEntity.m_6593_((Component)new TextComponent("Witchskall"));
    }

    @SubscribeEvent
    public static void onWitchTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level world = entity.f_19853_;
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof Witch)) {
            return;
        }
        Witch witchEntity = (Witch)entity;
        if (Witchskall.isWitchskall(witchEntity)) {
            return;
        }
        int witchskallTicks = Witchskall.getWitchskallificationTicks(witchEntity);
        if (witchskallTicks == 0) {
            return;
        }
        if (witchskallTicks <= -1) {
            Random random = new Random();
            if (random.nextFloat() <= 0.001f) {
                Witchskall.setWitchskallificationTicks(witchEntity, 100);
            } else {
                Witchskall.setWitchskallificationTicks(witchEntity, 0);
            }
            return;
        }
        int setWitchskallTicks = Witchskall.setWitchskallificationTicks(witchEntity, witchskallTicks - 1);
        if (setWitchskallTicks == 0) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.GREEN_FLAME.get()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 100, 0.5, 1.0, 0.5, 0.1);
            serverWorld.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ModSounds.WITCHSKALL_IDLE, SoundSource.MASTER, 1.1f, 1.0f);
            Witchskall.witchskallificate(witchEntity);
        }
    }

    @SubscribeEvent
    public static void onWitchskallDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (!(entity instanceof Witch) || !Witchskall.isWitchskall((Witch)entity)) {
            return;
        }
        Entity trueSource = event.getSource().m_7639_();
        if (!(trueSource instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)trueSource;
        AdvancementHelper.grantCriterion(player, VaultMod.id("main/witchskall"), "witchskall_killed");
    }

    @SubscribeEvent
    public static void onWitchskallDrops(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (!(entity instanceof Witch)) {
            return;
        }
        if (!Witchskall.isWitchskall((Witch)entity)) {
            return;
        }
        ServerLevel world = (ServerLevel)entity.f_19853_;
    }
}

