/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.entity.entity.DollMiniMeEntity;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;

public interface IPlayerSkinHolder {
    public static final EntityDataSerializer<Optional<GameProfile>> OPTIONAL_GAME_PROFILE_SERIALIZER = new EntityDataSerializer<Optional<GameProfile>>(){

        public void write(FriendlyByteBuf byteBuf, Optional<GameProfile> gameProfile) {
            byteBuf.writeBoolean(gameProfile.isPresent());
            gameProfile.ifPresent(gp -> {
                byteBuf.m_130077_(gp.getId());
                byteBuf.m_130070_(gp.getName());
            });
        }

        public Optional<GameProfile> read(FriendlyByteBuf byteBuf) {
            return !byteBuf.readBoolean() ? Optional.empty() : Optional.of(new GameProfile(byteBuf.m_130259_(), byteBuf.m_130277_()));
        }

        public Optional<GameProfile> copy(Optional<GameProfile> gameProfile) {
            return gameProfile;
        }
    };
    public static final EntityDataAccessor<Optional<GameProfile>> OPTIONAL_GAME_PROFILE = SynchedEntityData.m_135353_(DollMiniMeEntity.class, OPTIONAL_GAME_PROFILE_SERIALIZER);

    public Optional<GameProfile> getGameProfile();

    public void setGameProfile(GameProfile var1);

    public Optional<ResourceLocation> getSkinLocation();

    public boolean isUpdatingSkin();

    public void setSkinLocation(ResourceLocation var1);

    public void startUpdatingSkin();

    public void stopUpdatingSkin();

    public boolean hasSlimSkin();

    public void setSlimSkin(boolean var1);
}

