/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Targeting {
    private static final Set<TargetingOverride> targetingOverrides = new HashSet<TargetingOverride>();

    public static void addIgnoredTargetOverride(BiPredicate<LivingEntity, Entity> targetMatcher) {
        targetingOverrides.add((attacker, target) -> targetMatcher.test(attacker, target) ? TargetingResult.IGNORE : TargetingResult.DEFAULT);
    }

    public static void addForcedTargetOverride(BiPredicate<LivingEntity, Entity> targetMatcher) {
        targetingOverrides.add((attacker, target) -> targetMatcher.test(attacker, target) ? TargetingResult.TARGET : TargetingResult.DEFAULT);
    }

    public static TargetingResult getTargetingResult(LivingEntity attacker, Entity target) {
        for (TargetingOverride targetingOverride : targetingOverrides) {
            TargetingResult result = targetingOverride.getResult(attacker, target);
            if (result == TargetingResult.DEFAULT) continue;
            return result;
        }
        return TargetingResult.DEFAULT;
    }

    @SubscribeEvent
    public static void onTarget(LivingSetAttackTargetEvent event) {
        LivingEntity attacker = event.getEntityLiving();
        if (Targeting.getTargetingResult(attacker, (Entity)event.getTarget()) == TargetingResult.IGNORE && attacker instanceof Mob) {
            Mob mob = (Mob)attacker;
            mob.m_6710_(null);
            attacker.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            attacker.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        } else {
            attacker.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)event.getTarget());
            attacker.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        }
    }

    static {
        targetingOverrides.add((attacker, target) -> {
            Player player;
            return target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_()) ? TargetingResult.IGNORE : TargetingResult.DEFAULT;
        });
    }

    public static interface TargetingOverride {
        public TargetingResult getResult(LivingEntity var1, Entity var2);
    }

    public static enum TargetingResult {
        TARGET(true),
        IGNORE(false),
        DEFAULT(null);

        private Boolean shouldTarget;

        private TargetingResult(Boolean shouldTarget) {
            this.shouldTarget = shouldTarget;
        }

        public Boolean getShouldTarget() {
            return this.shouldTarget;
        }
    }
}

