/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.ai.GoalTask;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ChampionGoal {
    public static void registerProjectileGoal(Vault vault, final Mob mob) {
        VaultDifficulty vaultDifficulty = WorldSettings.get(mob.f_19853_).getPlayerDifficulty(vault.get(Vault.OWNER));
        if (vaultDifficulty.shouldChampionRangeAttack()) {
            mob.f_21345_.m_25352_(3, (Goal)new ThrowSpearGoal<Mob>(mob, ModConfigs.FIGHTER.chancerPerTick / 2, 1, ThrowableSpear::new){

                @Override
                public boolean m_8036_() {
                    return super.m_8036_() && this.targetOutOfReachAbove();
                }

                @Override
                public boolean m_8045_() {
                    return super.m_8045_() && this.targetOutOfReachAbove();
                }

                private boolean targetOutOfReachAbove() {
                    ChampionLogic.IChampionLogicHolder championLogicHolder;
                    LivingEntity target = mob.m_5448_();
                    if (target == null || !(mob instanceof ChampionLogic.IChampionLogicHolder) || (championLogicHolder = (ChampionLogic.IChampionLogicHolder)mob).getChampionLogic().isPacified()) {
                        return false;
                    }
                    double targetDistance = mob.m_20280_((Entity)target);
                    double attackReach = this.getAttackReachSqr(target);
                    double yDiff = target.m_20186_() - mob.m_20186_();
                    Path path = mob.m_21573_().m_26570_();
                    boolean stuck = mob.m_21573_().m_26577_();
                    boolean canNotReach = path == null || !path.m_77403_() || stuck;
                    return targetDistance > attackReach && targetDistance < attackReach * 16.0 && (yDiff >= 2.0 && yDiff <= 4.0 || canNotReach && mob.f_19797_ > 20);
                }

                private double getAttackReachSqr(LivingEntity pAttackTarget) {
                    return mob.m_20205_() * 2.0f * mob.m_20205_() * 2.0f + pAttackTarget.m_20205_();
                }
            });
        }
    }

    public static class ThrowSpearGoal<T extends Mob>
    extends GoalTask<T> {
        private final int chance;
        private final int count;
        private final Projectile projectile;
        private int progress;
        private int waitTicks;

        public ThrowSpearGoal(T entity, int chance, int count, Projectile projectile) {
            super(entity);
            this.chance = chance;
            this.count = count;
            this.projectile = projectile;
            this.waitTicks = 0;
        }

        public boolean m_8036_() {
            return ((Mob)this.getEntity()).m_5448_() != null;
        }

        public boolean m_8045_() {
            return ((Mob)this.getEntity()).m_5448_() != null && this.progress < this.count;
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            if (this.waitTicks < 40) {
                ++this.waitTicks;
            } else {
                Entity throwEntity = this.projectile.create(this.getWorld(), (LivingEntity)this.getEntity());
                LivingEntity target = ((Mob)this.getEntity()).m_5448_();
                if (target != null) {
                    double d0 = target.m_20188_() - (double)1.1f;
                    double d1 = target.m_20185_() - ((Mob)this.getEntity()).m_20185_();
                    double d2 = d0 - throwEntity.m_20186_();
                    double d3 = target.m_20189_() - ((Mob)this.getEntity()).m_20189_();
                    float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
                    this.shoot(throwEntity, d1, d2 + (double)f, d3, 1.6f, 4.0f, this.getWorld().f_46441_);
                    this.getWorld().m_5594_(null, ((Mob)this.getEntity()).m_142538_(), SoundEvents.f_12479_, SoundSource.HOSTILE, 1.0f, 0.4f / (this.getWorld().f_46441_.nextFloat() * 0.4f + 0.8f));
                    this.getWorld().m_7967_(throwEntity);
                }
                this.waitTicks = 0;
                ++this.progress;
            }
        }

        public void shoot(Entity projectile, double x, double y, double z, float velocity, float inaccuracy, Random rand) {
            Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(rand.nextGaussian() * (double)0.0075f * (double)inaccuracy, rand.nextGaussian() * (double)0.0075f * (double)inaccuracy, rand.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
            projectile.m_20256_(vector3d);
            float f = Mth.m_14116_((float)((float)vector3d.m_165925_()));
            projectile.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
            projectile.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
            projectile.f_19859_ = projectile.m_146908_();
            projectile.f_19860_ = projectile.m_146909_();
        }

        public void m_8041_() {
            this.progress = 0;
        }

        public static interface Projectile {
            public Entity create(Level var1, LivingEntity var2);
        }
    }

    public static class ThrowableSpear
    extends ThrowableItemProjectile {
        @Nullable
        private LivingEntity thrower;

        public ThrowableSpear(EntityType<ThrowableSpear> entityType, Level level) {
            super(entityType, level);
        }

        public ThrowableSpear(Level level, LivingEntity thrower) {
            super(ModEntities.SPEAR, thrower, level);
            this.thrower = thrower;
        }

        protected Item m_7881_() {
            return Items.f_42613_;
        }

        protected boolean m_5603_(Entity entity) {
            return entity instanceof Player;
        }

        protected void m_8060_(BlockHitResult p_37258_) {
        }

        protected void m_5790_(EntityHitResult result) {
            if (this.f_19853_.m_5776_()) {
                return;
            }
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.thrower == null) {
                    this.m_146870_();
                    return;
                }
                double xRatio = this.thrower.m_20185_() - livingEntity.m_20185_();
                double zRatio = this.thrower.m_20189_() - livingEntity.m_20189_();
                while (xRatio * xRatio + zRatio * zRatio < 1.0E-4) {
                    xRatio = (Math.random() - Math.random()) * 0.01;
                    zRatio = (Math.random() - Math.random()) * 0.01;
                }
                livingEntity.f_19864_ = true;
                EntityHelper.knockbackIgnoreResist(livingEntity, this.thrower, (float)ModConfigs.FIGHTER.knockback * 2.0f);
                livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this.thrower), (float)this.thrower.m_21133_(Attributes.f_22281_) / 2.0f);
            }
        }
    }
}

