/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai;

import iskallia.vault.init.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;

public class TeleportRandomly<T extends LivingEntity>
implements INBTSerializable<CompoundTag> {
    protected T entity;
    private final Condition<T>[] conditions;

    public TeleportRandomly(T entity) {
        this(entity, new Condition[0]);
    }

    public TeleportRandomly(T entity, Condition<T> ... conditions) {
        this.entity = entity;
        this.conditions = conditions;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        for (Condition<T> condition : this.conditions) {
            double chance = condition.getChance(this.entity, source, amount);
            if (!(((LivingEntity)this.entity).f_19853_.f_46441_.nextDouble() < chance)) continue;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                ((LivingEntity)this.entity).f_19853_.m_6263_(null, ((LivingEntity)this.entity).f_19854_, ((LivingEntity)this.entity).f_19855_, ((LivingEntity)this.entity).f_19856_, ModSounds.BOSS_TP_SFX, this.entity.m_5720_(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (!((LivingEntity)this.entity).f_19853_.m_5776_() && this.entity.m_6084_()) {
            double d0 = this.entity.m_20185_() + (((LivingEntity)this.entity).f_19853_.f_46441_.nextDouble() - 0.5) * 64.0;
            double d1 = this.entity.m_20186_() + (double)(((LivingEntity)this.entity).f_19853_.f_46441_.nextInt(64) - 32);
            double d2 = this.entity.m_20189_() + (((LivingEntity)this.entity).f_19853_.f_46441_.nextDouble() - 0.5) * 64.0;
            return this.entity.m_20984_(d0, d1, d2, true);
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    public static <T extends LivingEntity> TeleportRandomly<T> fromNBT(T entity, CompoundTag nbt) {
        TeleportRandomly<T> tp = new TeleportRandomly<T>(entity);
        tp.deserializeNBT(nbt);
        return tp;
    }

    @FunctionalInterface
    public static interface Condition<T extends LivingEntity> {
        public double getChance(T var1, DamageSource var2, double var3);
    }
}

