/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.IMeleeAttack;
import iskallia.vault.init.ModSounds;
import java.util.Optional;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BasicMeleeAttack
implements IMeleeAttack {
    private final double damageMultiplier;
    private final BasicMeleeAttackAttributes attackData;
    private int damageCooldown = 0;
    private int targetId = -1;
    private final ArtifactBossEntity boss;

    public BasicMeleeAttack(ArtifactBossEntity boss, double damageMultiplier, BasicMeleeAttackAttributes attackData) {
        this.boss = boss;
        this.damageMultiplier = damageMultiplier;
        this.attackData = attackData;
    }

    @Override
    public boolean start(LivingEntity target, double distToTarget, double reach) {
        if (this.targetId == -1) {
            if (this.canAttack(distToTarget, reach, this.attackData, this.boss.m_5448_())) {
                this.targetId = target.m_142049_();
                this.damageCooldown = this.attackData.damageCooldown();
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean canAttack(double distToEnemy, double reach, BasicMeleeAttackAttributes attackData, LivingEntity target) {
        return distToEnemy <= reach && this.isWithinAttackableSlice(this.boss, target, attackData.attackableSlice().closenessRatioRequired(), attackData.attackableSlice().angleOffset());
    }

    public boolean isWithinAttackableSlice(LivingEntity target) {
        return this.isWithinAttackableSlice(this.boss, target, this.attackData.attackableSlice().closenessRatioRequired(), this.attackData.attackableSlice().angleOffset());
    }

    @Override
    public void stop() {
        this.targetId = -1;
    }

    @Override
    public void tick(double reach) {
        Entity entity;
        if (this.targetId > -1 && (entity = this.boss.m_183503_().m_6815_(this.targetId)) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (--this.damageCooldown <= 0) {
                this.boss.m_183503_().m_45955_(PLAYERS_HIT_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(reach)).forEach(player -> {
                    double pDistToEnemySqr;
                    if (this.isWithinAttackableSlice((LivingEntity)player) && (pDistToEnemySqr = this.boss.m_20280_((Entity)player)) <= reach) {
                        this.doHurtTarget((Entity)player);
                        this.targetId = -1;
                    }
                });
            } else if (this.damageCooldown > 0 && !this.isWithinAttackableSlice(target)) {
                this.rotateTowardTarget(target);
            }
        }
    }

    protected void rotateTowardTarget(LivingEntity target) {
        if (target == null) {
            return;
        }
        double xDiff = target.m_20185_() - this.boss.m_20185_();
        double zDiff = target.m_20189_() - this.boss.m_20189_();
        if (Math.abs(zDiff) <= (double)1.0E-5f && Math.abs(xDiff) <= (double)1.0E-5f) {
            return;
        }
        float targetAtAngle = (float)(Mth.m_14136_((double)zDiff, (double)xDiff) * 57.2957763671875) - 90.0f;
        float maxDelta = 1.0f;
        float angleDiff = Mth.m_14118_((float)this.boss.m_146908_(), (float)targetAtAngle);
        float rotateBy = Mth.m_14036_((float)angleDiff, (float)(-maxDelta), (float)maxDelta);
        float newYRot = this.boss.m_146908_() + rotateBy;
        this.boss.m_146922_(newYRot);
        this.boss.m_5618_(newYRot);
        this.boss.m_146867_();
        this.boss.f_19812_ = true;
    }

    public boolean doHurtTarget(Entity target) {
        double baseDamage = this.boss.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), (float)(baseDamage * this.damageMultiplier));
        if (flag) {
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                this.knockbackTarget(this.boss, livingTarget, this.attackData.horizontalKnockbackMultiplier(), this.attackData.verticalKnockbackMultiplier());
            }
            this.boss.m_21335_(target);
        }
        this.boss.f_19853_.m_5594_(null, this.boss.m_142538_(), ModSounds.ARTIFACT_BOSS_ATTACK, SoundSource.HOSTILE, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public int getDuration() {
        return this.attackData.swingDuration();
    }

    @Override
    public Optional<ArtifactBossEntity.AttackMove> getAttackMove() {
        return this.attackData == null ? Optional.empty() : Optional.of(this.attackData.attackMove());
    }

    public record BasicMeleeAttackAttributes(Slice attackableSlice, int swingDuration, int damageCooldown, ArtifactBossEntity.AttackMove attackMove, float horizontalKnockbackMultiplier, float verticalKnockbackMultiplier) {

        public record Slice(float angleOffset, float closenessRatioRequired) {
        }
    }
}

