/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.MeleeAttacks;
import iskallia.vault.entity.boss.MeleeStageAttributes;
import net.minecraft.nbt.CompoundTag;

public class BerserkStageAttributes
extends MeleeStageAttributes {
    private final double maxSpeedMultiplier;
    private final double maxBaseDamageMultiplier;
    private final int bloodOrbSpawnCooldown;
    private final int maxBloodOrbs;

    public BerserkStageAttributes(int health, int baseAttackDamage, double baseSpeed, double maxSpeedMultiplier, double maxBaseDamageMultiplier, WeightedList<MeleeAttacks.AttackData> meleeAttacks, WeightedList<MeleeAttacks.AttackData> rageAttacks, int bloodOrbSpawnCooldown, int maxBloodOrbs) {
        super(health, baseAttackDamage, baseSpeed, meleeAttacks, rageAttacks);
        this.maxSpeedMultiplier = maxSpeedMultiplier;
        this.maxBaseDamageMultiplier = maxBaseDamageMultiplier;
        this.bloodOrbSpawnCooldown = bloodOrbSpawnCooldown;
        this.maxBloodOrbs = maxBloodOrbs;
    }

    public double getMaxSpeedMultiplier() {
        return this.maxSpeedMultiplier;
    }

    public double getMaxBaseDamageMultiplier() {
        return this.maxBaseDamageMultiplier;
    }

    public int getBloodOrbSpawnCooldown() {
        return this.bloodOrbSpawnCooldown;
    }

    public int getMaxBloodOrbs() {
        return this.maxBloodOrbs;
    }

    public static BerserkStageAttributes from(CompoundTag tag) {
        return new BerserkStageAttributes(tag.m_128451_("Health"), tag.m_128451_("AttackDamage"), tag.m_128459_("Speed"), tag.m_128459_("MaxSpeedMultiplier"), tag.m_128459_("MaxBaseDamageMultiplier"), BerserkStageAttributes.deserializeAttacks(tag.m_128437_("MeleeAttacks", 10)), BerserkStageAttributes.deserializeAttacks(tag.m_128437_("RageAttacks", 10)), tag.m_128451_("BloodOrbSpawnCooldown"), tag.m_128451_("MaxBloodOrbs"));
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.m_128347_("MaxSpeedMultiplier", this.maxSpeedMultiplier);
        tag.m_128347_("MaxBaseDamageMultiplier", this.maxBaseDamageMultiplier);
        tag.m_128405_("BloodOrbSpawnCooldown", this.bloodOrbSpawnCooldown);
        tag.m_128405_("MaxBloodOrbs", this.maxBloodOrbs);
        return tag;
    }
}

