/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.client.gui.helper.Easing;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.BossProtectionCatalystEntity;
import iskallia.vault.entity.boss.CatalystStageAttributes;
import iskallia.vault.entity.boss.ConjurationMagicProjectileEntity;
import iskallia.vault.entity.boss.IBossStage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import software.bernie.geckolib3.core.builder.AnimationBuilder;

public class CatalystStage
implements IBossStage {
    public static final String NAME = "catalyst";
    private static final ResourceLocation BOSS_TEXTURE = new ResourceLocation("the_vault", "textures/entity/boss/artifact_boss_tenos.png");
    private static final Set<Goal.Flag> FLAGS = Set.of(Goal.Flag.MOVE, Goal.Flag.TARGET);
    private static final TargetingConditions PLAYERS_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(50.0);
    private static final int FLOAT_LEVEL = 10;
    private static final int MOVE_TIME = 40;
    private static final int PROJECTILE_COOLDOWN = 20;
    private final ArtifactBossEntity boss;
    private int projectileTimer = 20;
    private final CatalystStageAttributes attributes;
    private int catalystWaveIndex = -1;
    private int currentWaveCatalystCount = 0;
    private Set<UUID> catalystIds = new HashSet<UUID>();
    private boolean finished = false;
    private boolean movingUp = false;
    private boolean movingDown = false;
    private int moveTimer = 0;
    private int projectilesToShoot = 1;

    public CatalystStage(ArtifactBossEntity boss, CatalystStageAttributes attributes) {
        this.boss = boss;
        this.attributes = attributes;
        this.setProjectilesToShoot(boss);
    }

    private void setProjectilesToShoot(ArtifactBossEntity boss) {
        this.projectilesToShoot = boss.f_19853_.f_46441_.nextInt(Math.max(1, 4 - boss.getPlayerCount()), Math.max(3, 8 - boss.getPlayerCount()) + 1);
    }

    @Override
    public void tick() {
        if (this.boss.f_19853_.m_5776_()) {
            return;
        }
        if (this.movingUp) {
            --this.moveTimer;
            yOffset = 10.0f * (1.0f - Easing.EASE_IN_OUT_SINE.calc((float)this.moveTimer / 40.0f));
            this.boss.m_6034_(this.boss.getSpawnPosition().f_82479_, this.boss.getSpawnPosition().f_82480_ + (double)yOffset, this.boss.getSpawnPosition().f_82481_);
            if (this.moveTimer > 0) {
                return;
            }
            this.movingUp = false;
        } else if (this.movingDown) {
            --this.moveTimer;
            yOffset = 10.0f * Easing.EASE_IN_OUT_SINE.calc((float)this.moveTimer / 40.0f);
            this.boss.m_6034_(this.boss.getSpawnPosition().f_82479_, this.boss.getSpawnPosition().f_82480_ + (double)yOffset, this.boss.getSpawnPosition().f_82481_);
            if (this.moveTimer > 0) {
                return;
            }
            this.movingDown = false;
            this.finished = true;
        }
        Level level = this.boss.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.catalystIds.removeIf(id -> serverLevel.m_8791_(id) == null);
        }
        if (this.catalystIds.isEmpty()) {
            if (this.catalystWaveIndex < this.attributes.getCatalystWaves().size() - 1) {
                ++this.catalystWaveIndex;
                this.spawnCatalysts();
            } else {
                this.movingDown = true;
                this.moveTimer = 40;
            }
        }
        --this.projectileTimer;
        if (this.projectileTimer <= (this.projectilesToShoot - 1) * 2) {
            this.shootAtPlayers((float)(this.projectilesToShoot - 1) * 0.6f);
            --this.projectilesToShoot;
            if (this.projectilesToShoot <= 0) {
                this.projectileTimer = 20;
                this.setProjectilesToShoot(this.boss);
            }
        }
    }

    private void shootAtPlayers(float inaccuracy) {
        Level level = this.boss.m_183503_();
        level.m_45955_(PLAYERS_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(60.0)).forEach(player -> {
            double maxInaccuracy = Math.sqrt(Math.sqrt(this.boss.m_20280_((Entity)player))) * (double)inaccuracy;
            double x = player.m_20185_() - this.boss.m_20185_() + this.boss.f_19853_.f_46441_.nextGaussian() * maxInaccuracy;
            double y = player.m_20227_(0.5) - this.boss.m_20227_(0.5);
            double z = player.m_20189_() - this.boss.m_20189_() + this.boss.f_19853_.f_46441_.nextGaussian() * maxInaccuracy;
            ConjurationMagicProjectileEntity magicProjectile = new ConjurationMagicProjectileEntity(this.boss.m_183503_(), this.boss, x, y, z, (Player)player, this.attributes);
            magicProjectile.setColor(VaultGod.TENOS.getColor());
            magicProjectile.m_6034_(magicProjectile.m_20185_(), this.boss.m_20227_(0.5) + 0.5, magicProjectile.m_20189_());
            this.boss.m_183503_().m_7967_((Entity)magicProjectile);
        });
    }

    private void spawnCatalysts() {
        CatalystStageAttributes.CatalystWave wave = this.attributes.getCatalystWaves().get(this.catalystWaveIndex);
        this.currentWaveCatalystCount = this.boss.f_19853_.f_46441_.nextInt(wave.minCatalysts() + (this.boss.getPlayerCount() - 1), wave.maxCatalysts() + (this.boss.getPlayerCount() - 1) + 1);
        double angle = Math.PI * 2 / (double)this.currentWaveCatalystCount;
        for (int i = 0; i < this.currentWaveCatalystCount; ++i) {
            double catalystAngle = (double)i * angle;
            BossProtectionCatalystEntity.CatalystType[] catalystTypes = BossProtectionCatalystEntity.CatalystType.values();
            BossProtectionCatalystEntity.CatalystType catalystType = catalystTypes[this.boss.f_19853_.f_46441_.nextInt(catalystTypes.length)];
            BossProtectionCatalystEntity catalyst = new BossProtectionCatalystEntity(this.boss.f_19853_, this.boss.getSpawnPosition(), (float)catalystAngle, catalystType, this.attributes.getExplosionDamageMultiplier());
            this.boss.f_19853_.m_7967_((Entity)catalyst);
            this.catalystIds.add(catalyst.m_142081_());
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean makesBossInvulnerable() {
        return true;
    }

    @Override
    public Set<Goal.Flag> getControlFlags() {
        return FLAGS;
    }

    @Override
    public void init() {
        this.movingUp = true;
        this.moveTimer = 40;
        this.boss.m_20242_(true);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void finish() {
        this.boss.m_20242_(false);
        this.clearChests();
    }

    private void clearChests() {
        if (this.boss.f_19853_.m_5776_()) {
            return;
        }
        BlockPos pos = this.boss.m_20097_();
        BlockPos.m_121940_((BlockPos)pos.m_142082_(-50, 0, -50), (BlockPos)pos.m_142082_(50, 3, 50)).forEach(blockPos -> {
            if (this.boss.f_19853_.m_8055_(blockPos).m_60734_() instanceof VaultChestBlock) {
                this.boss.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Optional<AnimationBuilder> getAnimation() {
        return Optional.of(ArtifactBossEntity.SUMMON_ANIM);
    }

    @Override
    public Optional<ResourceLocation> getTextureLocation() {
        return Optional.of(BOSS_TEXTURE);
    }

    @Override
    public Tuple<Integer, Integer> getBossBarTextureVs() {
        return new Tuple((Object)124, (Object)341);
    }

    @Override
    public float getProgress() {
        if (this.catalystWaveIndex == -1) {
            return 1.0f;
        }
        int waveCount = this.attributes.getCatalystWaves().size();
        float singleWaveProgress = 1.0f / (float)waveCount;
        return (float)(waveCount - this.catalystWaveIndex) * singleWaveProgress - singleWaveProgress * (1.0f - (float)this.catalystIds.size() / (float)this.currentWaveCatalystCount);
    }

    public static CatalystStage fromAttributes(ArtifactBossEntity artifactBossEntity, CompoundTag attributesTag) {
        return new CatalystStage(artifactBossEntity, CatalystStageAttributes.from(attributesTag));
    }

    public static CatalystStage from(ArtifactBossEntity artifactBossEntity, CompoundTag tag) {
        CatalystStage catalystStage = CatalystStage.fromAttributes(artifactBossEntity, tag.m_128469_("Attributes"));
        catalystStage.catalystWaveIndex = tag.m_128451_("CatalystWaveIndex");
        catalystStage.currentWaveCatalystCount = tag.m_128451_("CurrentWaveCatalystCount");
        catalystStage.catalystIds = CatalystStage.deserializeCatalystIds(tag.m_128437_("CatalystIds", 11));
        catalystStage.movingUp = tag.m_128471_("MovingUp");
        catalystStage.movingDown = tag.m_128471_("MovingDown");
        catalystStage.moveTimer = tag.m_128451_("MoveTimer");
        return catalystStage;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = IBossStage.super.serialize();
        tag.m_128365_("Attributes", (Tag)this.attributes.serialize());
        tag.m_128405_("CatalystWaveIndex", this.catalystWaveIndex);
        tag.m_128405_("CurrentWaveCatalystCount", this.currentWaveCatalystCount);
        tag.m_128365_("CatalystIds", (Tag)this.serializeCatalystIds());
        tag.m_128379_("MovingUp", this.movingUp);
        tag.m_128379_("MovingDown", this.movingDown);
        tag.m_128405_("MoveTimer", this.moveTimer);
        return tag;
    }

    private ListTag serializeCatalystIds() {
        ListTag listTag = new ListTag();
        for (UUID id : this.catalystIds) {
            listTag.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        return listTag;
    }

    private static Set<UUID> deserializeCatalystIds(ListTag listTag) {
        HashSet<UUID> catalystIds = new HashSet<UUID>();
        for (Tag tag : listTag) {
            catalystIds.add(NbtUtils.m_129233_((Tag)tag));
        }
        return catalystIds;
    }
}

