/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.entity.boss.AreaOfEffectBossEntity;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.CatalystStageAttributes;
import iskallia.vault.entity.boss.MagicProjectileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEntities;
import iskallia.vault.mixin.AccessorChunkMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.mutable.MutableObject;

public class ConjurationMagicProjectileEntity
extends MagicProjectileEntity {
    private float chestChance;
    private float fangsChance;
    private float fangsDamage;
    private WeightedList<CatalystStageAttributes.EffectAttributes> effects = (WeightedList)WeightedList.empty();
    private Map<VaultChestType, ResourceLocation> chestLootTables = Collections.emptyMap();

    protected ConjurationMagicProjectileEntity(Level level, ArtifactBossEntity boss, double x, double y, double z, Player target, CatalystStageAttributes attributes) {
        super(ModEntities.CONJURATION_MAGIC_PROJECTILE, level, boss, x, y, z, target, attributes.getProjectileDamage());
        this.chestChance = attributes.getChestChance();
        this.fangsChance = attributes.getFangsChance();
        this.fangsDamage = attributes.getFangsDamage();
        this.effects = attributes.getEffects();
        this.chestLootTables = attributes.getChestLootTables();
    }

    public ConjurationMagicProjectileEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        if (hitResult.m_82434_() == Direction.UP) {
            if (this.f_19853_.f_46441_.nextFloat() < this.chestChance) {
                this.placeChest(hitResult);
            } else if (this.f_19853_.f_46441_.nextFloat() < this.fangsChance) {
                this.summonFangs(hitResult);
            } else {
                this.summonAreaEffectCloud(hitResult);
            }
        }
    }

    private void placeChest(BlockHitResult hitResult) {
        BlockPos chestPos = hitResult.m_82425_().m_7494_();
        Block chestBlock = this.getRandomChestBlock();
        this.f_19853_.m_46597_(chestPos, chestBlock.m_49966_());
        this.f_19853_.m_141902_(chestPos, ModBlocks.VAULT_CHEST_TILE_ENTITY).ifPresent(chest -> chest.m_59626_(this.getChestLoottable(chestBlock), this.f_19853_.f_46441_.nextLong()));
        this.f_19853_.m_142572_().m_6937_((Runnable)new TickTask(this.f_19853_.m_142572_().m_129921_() + 1, () -> {
            ((ServerChunkCache)this.f_19853_.m_7726_()).f_8325_.m_183262_(new ChunkPos(chestPos), false).forEach(player -> {
                this.f_19853_.m_6522_(new ChunkPos((BlockPos)chestPos).f_45578_, new ChunkPos((BlockPos)chestPos).f_45579_, ChunkStatus.f_62326_, true);
                ((AccessorChunkMap)((ServerChunkCache)this.f_19853_.m_7726_()).f_8325_).callUpdateChunkTracking((ServerPlayer)player, new ChunkPos(chestPos), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
            });
            ((ServerChunkCache)this.f_19853_.m_7726_()).m_8450_(chestPos);
        }));
    }

    private ResourceLocation getChestLoottable(Block chestBlock) {
        VaultChestBlock vaultChestBlock;
        if (chestBlock instanceof VaultChestBlock && this.chestLootTables.containsKey((Object)(vaultChestBlock = (VaultChestBlock)chestBlock).getType())) {
            return this.chestLootTables.getOrDefault((Object)vaultChestBlock.getType(), new ResourceLocation(""));
        }
        return this.chestLootTables.get((Object)VaultChestType.WOODEN);
    }

    private Block getRandomChestBlock() {
        return switch (this.f_19853_.f_46441_.nextInt(4)) {
            case 0 -> ModBlocks.WOODEN_CHEST;
            case 1 -> ModBlocks.LIVING_CHEST;
            case 2 -> ModBlocks.GILDED_CHEST;
            case 3 -> ModBlocks.ORNATE_CHEST;
            default -> ModBlocks.WOODEN_CHEST;
        };
    }

    private void summonFangs(BlockHitResult hitResult) {
        this.spawnFangs(hitResult, 4, 1);
        this.spawnFangs(hitResult, 4, 2);
        this.spawnFangs(hitResult, 4, 3);
        this.spawnFangs(hitResult, 4, 4);
        this.spawnFangs(hitResult, 4, 8);
    }

    private void spawnFangs(BlockHitResult hitResult, int numberOfFangs, int fangRadius) {
        for (int i = 0; i < numberOfFangs; ++i) {
            double x = hitResult.m_82450_().f_82479_ + (double)this.f_19853_.f_46441_.nextInt(fangRadius * 2) - (double)fangRadius;
            double z = hitResult.m_82450_().f_82481_ + (double)this.f_19853_.f_46441_.nextInt(fangRadius * 2) - (double)fangRadius;
            this.f_19853_.m_7967_((Entity)new EvokerFangs(this.f_19853_, x, hitResult.m_82425_().m_123342_() + 1, z, this.f_19853_.f_46441_.nextFloat((float)Math.PI), this.f_19853_.f_46441_.nextInt(10), null){

                public void m_36944_(LivingEntity livingEntity) {
                    if (livingEntity.m_6084_() && !livingEntity.m_20147_()) {
                        livingEntity.m_6469_(DamageSource.f_19319_, ConjurationMagicProjectileEntity.this.fangsDamage);
                    }
                }
            });
        }
    }

    private void summonAreaEffectCloud(BlockHitResult hitResult) {
        if (this.effects.isEmpty()) {
            return;
        }
        this.effects.getRandom(this.f_19853_.f_46441_).ifPresent(effectAttributes -> {
            BlockPos hitPos = hitResult.m_82425_();
            AreaOfEffectBossEntity areaEffectCloud = new AreaOfEffectBossEntity(this.f_19853_, (double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 1.5, (double)hitPos.m_123343_() + 0.5);
            areaEffectCloud.m_19712_(8.0f);
            areaEffectCloud.m_19732_(-0.1f);
            areaEffectCloud.m_19740_(0);
            areaEffectCloud.m_19734_(160);
            areaEffectCloud.m_19716_(new MobEffectInstance(effectAttributes.effect(), effectAttributes.duration(), effectAttributes.amplifier()));
            areaEffectCloud.m_19738_(0.0f);
            areaEffectCloud.m_19714_(VaultGod.TENOS.getColor());
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123770_);
            this.f_19853_.m_7967_((Entity)areaEffectCloud);
        });
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ChestChance", this.chestChance);
        tag.m_128350_("FangsChance", this.fangsChance);
        tag.m_128350_("FangsDamage", this.fangsDamage);
        tag.m_128365_("Effects", (Tag)CatalystStageAttributes.serializeEffects(this.effects));
        tag.m_128365_("ChestLootTables", (Tag)CatalystStageAttributes.serializeChestLootTables(this.chestLootTables));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.chestChance = tag.m_128457_("ChestChance");
        this.fangsChance = tag.m_128457_("FangsChance");
        this.fangsDamage = tag.m_128457_("FangsDamage");
        this.effects = CatalystStageAttributes.deserializeEffects(tag.m_128437_("Effects", 10));
        this.chestLootTables = CatalystStageAttributes.deserializeChestLootTables(tag.m_128469_("ChestLootTables"));
    }
}

