/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.entity.boss.ArtifactBossEntity;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public interface IMeleeAttack {
    public static final TargetingConditions PLAYERS_CLOSE_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(3.0);
    public static final TargetingConditions PLAYERS_HIT_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(7.0);

    public boolean start(LivingEntity var1, double var2, double var4);

    public void stop();

    public void tick(double var1);

    public int getDuration();

    public Optional<ArtifactBossEntity.AttackMove> getAttackMove();

    default public boolean isWithinAttackableSlice(ArtifactBossEntity boss, LivingEntity target, float closenessRatioRequired, float angleOffset) {
        if (target == null) {
            return false;
        }
        Vec3 bossViewVector = boss.calculateViewVector(boss.m_5675_(1.0f) + angleOffset).m_82541_();
        Vec3 positionsVector = new Vec3(target.m_20185_() - boss.m_20185_(), target.m_20188_() - boss.m_20188_(), target.m_20189_() - boss.m_20189_());
        double closenessRatio = bossViewVector.m_82526_(positionsVector = positionsVector.m_82541_());
        return closenessRatio > (double)closenessRatioRequired;
    }

    default public void knockbackTarget(ArtifactBossEntity boss, LivingEntity target, double horizontalKnockbackMultiplier, double verticalKnockbackMultiplier) {
        double strength = boss.m_21133_(Attributes.f_22282_);
        double ratioX = boss.m_20185_() - target.m_20185_();
        double ratioZ = boss.m_20189_() - target.m_20189_();
        while (ratioX * ratioX + ratioZ * ratioZ < 1.0E-4) {
            ratioX = (Math.random() - Math.random()) * 0.01;
            ratioZ = (Math.random() - Math.random()) * 0.01;
        }
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)((float)strength), (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if ((strength *= 1.0 - target.m_21133_(Attributes.f_22278_) / 2.0) > 0.0) {
            target.f_19812_ = true;
            Vec3 vec3 = target.m_20184_();
            Vec3 vec31 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_(strength * horizontalKnockbackMultiplier);
            target.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 + strength * verticalKnockbackMultiplier, vec3.f_82481_ / 2.0 - vec31.f_82481_);
        }
    }
}

