/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.IBossStage;
import iskallia.vault.entity.boss.MeleeAttacks;
import iskallia.vault.entity.boss.MeleeStageAttributes;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import software.bernie.geckolib3.core.builder.AnimationBuilder;

public class MeleeStage<T extends MeleeStageAttributes>
implements IBossStage {
    public static final String NAME = "melee";
    protected final ArtifactBossEntity boss;
    protected final T meleeStageAttributes;

    public MeleeStage(ArtifactBossEntity boss, T meleeStageAttributes) {
        this.boss = boss;
        this.meleeStageAttributes = meleeStageAttributes;
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean isFinished() {
        return this.boss.isCloseToDeath();
    }

    @Override
    public boolean makesBossInvulnerable() {
        return false;
    }

    @Override
    public Set<Goal.Flag> getControlFlags() {
        return Set.of();
    }

    @Override
    public void init() {
        this.boss.setScaledHealth(((MeleeStageAttributes)this.meleeStageAttributes).getHealth() * this.boss.getPlayerCount());
        this.boss.setScaledDamage(((MeleeStageAttributes)this.meleeStageAttributes).getBaseAttackDamage());
        this.boss.m_21051_(Attributes.f_22279_).m_22100_(((MeleeStageAttributes)this.meleeStageAttributes).getBaseSpeed());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void finish() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Optional<AnimationBuilder> getAnimation() {
        return Optional.empty();
    }

    @Override
    public Optional<ResourceLocation> getTextureLocation() {
        return Optional.empty();
    }

    @Override
    public Tuple<Integer, Integer> getBossBarTextureVs() {
        return new Tuple((Object)0, (Object)319);
    }

    @Override
    public WeightedList<MeleeAttacks.AttackData> getMeleeAttacks() {
        return ((MeleeStageAttributes)this.meleeStageAttributes).getMeleeAttacks();
    }

    @Override
    public WeightedList<MeleeAttacks.AttackData> getRageAttacks() {
        return ((MeleeStageAttributes)this.meleeStageAttributes).getRageAttacks();
    }

    @Override
    public float getProgress() {
        return this.boss.m_21223_() / this.boss.m_21233_();
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = IBossStage.super.serialize();
        tag.m_128365_("MeleeStageAttributes", (Tag)((MeleeStageAttributes)this.meleeStageAttributes).serialize());
        return tag;
    }

    public static MeleeStage fromAttributes(ArtifactBossEntity artifactBossEntity, CompoundTag attributesTag) {
        return new MeleeStage<MeleeStageAttributes>(artifactBossEntity, MeleeStageAttributes.from(attributesTag));
    }

    public static MeleeStage from(ArtifactBossEntity artifactBossEntity, CompoundTag tag) {
        return MeleeStage.fromAttributes(artifactBossEntity, tag.m_128469_("MeleeStageAttributes"));
    }
}

