/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.MeleeAttacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class MeleeStageAttributes {
    private final int health;
    private final int baseAttackDamage;
    private final double baseSpeed;
    private final WeightedList<MeleeAttacks.AttackData> meleeAttacks;
    private final WeightedList<MeleeAttacks.AttackData> rageAttacks;

    public MeleeStageAttributes(int health, int baseAttackDamage, double baseSpeed, WeightedList<MeleeAttacks.AttackData> meleeAttacks, WeightedList<MeleeAttacks.AttackData> rageAttacks) {
        this.health = health;
        this.baseAttackDamage = baseAttackDamage;
        this.baseSpeed = baseSpeed;
        this.meleeAttacks = meleeAttacks;
        this.rageAttacks = rageAttacks;
    }

    public int getHealth() {
        return this.health;
    }

    public double getBaseAttackDamage() {
        return this.baseAttackDamage;
    }

    public double getBaseSpeed() {
        return this.baseSpeed;
    }

    public WeightedList<MeleeAttacks.AttackData> getMeleeAttacks() {
        return this.meleeAttacks;
    }

    public WeightedList<MeleeAttacks.AttackData> getRageAttacks() {
        return this.rageAttacks;
    }

    public static MeleeStageAttributes from(CompoundTag tag) {
        return new MeleeStageAttributes(tag.m_128451_("Health"), tag.m_128451_("AttackDamage"), tag.m_128459_("Speed"), MeleeStageAttributes.deserializeAttacks(tag.m_128437_("MeleeAttacks", 10)), MeleeStageAttributes.deserializeAttacks(tag.m_128437_("RageAttacks", 10)));
    }

    protected static WeightedList<MeleeAttacks.AttackData> deserializeAttacks(ListTag tag) {
        WeightedList<MeleeAttacks.AttackData> weightedList = new WeightedList<MeleeAttacks.AttackData>();
        for (Tag element : tag) {
            CompoundTag compoundTag = (CompoundTag)element;
            weightedList.add(MeleeAttacks.AttackData.from(compoundTag), compoundTag.m_128459_("Weight"));
        }
        return weightedList;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Health", this.health);
        tag.m_128405_("AttackDamage", this.baseAttackDamage);
        tag.m_128347_("Speed", this.baseSpeed);
        tag.m_128365_("MeleeAttacks", (Tag)this.serializeAttacks(this.meleeAttacks));
        tag.m_128365_("RageAttacks", (Tag)this.serializeAttacks(this.rageAttacks));
        return tag;
    }

    private ListTag serializeAttacks(WeightedList<MeleeAttacks.AttackData> attacks) {
        ListTag tag = new ListTag();
        attacks.forEach((attackData, weight) -> {
            CompoundTag compoundTag = new CompoundTag();
            attackData.serializeTo(compoundTag);
            compoundTag.m_128347_("Weight", weight.doubleValue());
            tag.add((Object)compoundTag);
        });
        return tag;
    }
}

