/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.core.util.WeightedList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class SummoningStageAttributes {
    WeightedList<EntitySpawnData> entityTypes;
    int maxMobsAliveBeforeNextSpawn;
    int radius;
    int minMobCount;
    int maxMobCount;
    int minGroupCount;
    int maxGroupCount;

    public SummoningStageAttributes(WeightedList<EntitySpawnData> entityTypes, int maxMobsAliveBeforeNextSpawn, int radius, int minMobCount, int maxMobCount, int minGroupCount, int maxGroupCount) {
        this.entityTypes = entityTypes;
        this.maxMobsAliveBeforeNextSpawn = maxMobsAliveBeforeNextSpawn;
        this.radius = radius;
        this.minMobCount = minMobCount;
        this.maxMobCount = maxMobCount;
        this.minGroupCount = minGroupCount;
        this.maxGroupCount = maxGroupCount;
    }

    public static SummoningStageAttributes from(CompoundTag tag) {
        return new SummoningStageAttributes(SummoningStageAttributes.deserializeEntityTypes(tag.m_128437_("EntityTypes", 10)), tag.m_128451_("MaxMobsAliveBeforeNextSpawn"), tag.m_128451_("Radius"), tag.m_128451_("MinMobCount"), tag.m_128451_("MaxMobCount"), tag.m_128451_("MinGroupCount"), tag.m_128451_("MaxGroupCount"));
    }

    private static WeightedList<EntitySpawnData> deserializeEntityTypes(ListTag tag) {
        WeightedList<EntitySpawnData> weightedList = new WeightedList<EntitySpawnData>();
        for (Tag element : tag) {
            CompoundTag compoundTag = (CompoundTag)element;
            EntitySpawnData.from(compoundTag).ifPresent(entitySpawnData -> weightedList.put((EntitySpawnData)entitySpawnData, compoundTag.m_128459_("Weight")));
        }
        return weightedList;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("EntityTypes", (Tag)this.serializeEntityTypes());
        tag.m_128405_("MaxMobsAliveBeforeNextSpawn", this.maxMobsAliveBeforeNextSpawn);
        tag.m_128405_("Radius", this.radius);
        tag.m_128405_("MinMobCount", this.minMobCount);
        tag.m_128405_("MaxMobCount", this.maxMobCount);
        tag.m_128405_("MinGroupCount", this.minGroupCount);
        tag.m_128405_("MaxGroupCount", this.maxGroupCount);
        return tag;
    }

    private ListTag serializeEntityTypes() {
        ListTag tag = new ListTag();
        this.entityTypes.forEach((entityType, weight) -> {
            CompoundTag compoundTag = new CompoundTag();
            entityType.serializeTo(compoundTag);
            compoundTag.m_128347_("Weight", weight.doubleValue());
            tag.add((Object)compoundTag);
        });
        return tag;
    }

    public record EntitySpawnData(EntityType<?> entityType, @Nullable CompoundTag entityNbt) {
        public static Optional<EntitySpawnData> from(CompoundTag tag) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.m_128461_("EntityType")));
            CompoundTag entityNbt = tag.m_128441_("EntityNbt") ? tag.m_128469_("EntityNbt") : null;
            return entityType == null ? Optional.empty() : Optional.of(new EntitySpawnData(entityType, entityNbt));
        }

        public CompoundTag serializeTo(CompoundTag tag) {
            tag.m_128359_("EntityType", this.entityType.getRegistryName().toString());
            if (this.entityNbt != null) {
                tag.m_128365_("EntityNbt", (Tag)this.entityNbt);
            }
            return tag;
        }
    }
}

