/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.champion;

import iskallia.vault.config.ChampionsConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.entity.ai.ChampionGoal;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.champion.ChampionAffixRegistry;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.entity.entity.VaultGuardianEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldSettings;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.Range;

public class ChampionPromoter {
    private static final String NO_CHAMPION_TAG = "no_champion";

    public static void applyRandomChampion(LivingEntity entity) {
        if (entity.m_19880_().contains(NO_CHAMPION_TAG) || entity instanceof SpiritEntity || entity instanceof ArtifactBossEntity || entity instanceof VaultGuardianEntity || entity.m_21023_(ModEffects.IMMORTALITY)) {
            return;
        }
        double chance = ModConfigs.CHAMPIONS.defaultChampionChance;
        for (Map.Entry<EntityPredicate, Float> entry : ModConfigs.CHAMPIONS.entityChampionChance.entrySet()) {
            EntityPredicate predicate = entry.getKey();
            if (!predicate.test((Entity)entity)) continue;
            chance = entry.getValue().floatValue();
            break;
        }
        chance = CommonEvents.CHAMPION_PROMOTE.invoke(entity, chance).getProbability();
        if (ChampionLogic.isChampion(entity) || (double)entity.f_19853_.f_46441_.nextFloat() < chance) {
            ChampionPromoter.applyChampionAttributes(entity);
            ChampionPromoter.applyAffixes(entity);
        }
    }

    private static void applyAffixes(LivingEntity entity) {
        if (entity instanceof ChampionLogic.IChampionLogicHolder) {
            ChampionLogic.IChampionLogicHolder championLogicHolder = (ChampionLogic.IChampionLogicHolder)entity;
            for (Map.Entry<EntityPredicate, WeightedList<CompoundTag>> entityAffixes : ModConfigs.CHAMPIONS.entityAffixesData.entrySet()) {
                if (!entityAffixes.getKey().test((Entity)entity)) continue;
                int numberOfAffixes = Math.min(ChampionPromoter.getNumberOfAffixes(entity.f_19853_), entityAffixes.getValue().size());
                for (int i = 0; i < numberOfAffixes; ++i) {
                    entityAffixes.getValue().getRandom(entity.m_183503_().f_46441_).flatMap(ChampionAffixRegistry::deserialize).ifPresent(championLogicHolder.getChampionLogic()::addAffix);
                }
            }
            championLogicHolder.getChampionLogic().syncClientData(entity, PacketDistributor.DIMENSION.with(() -> entity.f_19853_.m_46472_()));
        }
    }

    private static int getNumberOfAffixes(Level level) {
        return ServerVaults.get(level).map(vault -> {
            VaultDifficulty vaultDifficulty = WorldSettings.get(level).getPlayerDifficulty(vault.get(Vault.OWNER));
            Range<Integer> championAffixCount = vaultDifficulty.getChampionAffixCount();
            return (Integer)championAffixCount.getMinimum() < (Integer)championAffixCount.getMaximum() ? level.f_46441_.nextInt((Integer)championAffixCount.getMinimum(), (Integer)championAffixCount.getMaximum()) + 1 : (Integer)championAffixCount.getMinimum();
        }).orElse(0);
    }

    public static void applyChampionAttributes(LivingEntity entity) {
        entity.m_20049_("vault_champion");
        entity.m_5496_(SoundEvents.f_12049_, 1.0f, 1.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            ServerVaults.get(mob.f_19853_).ifPresent(vault -> ChampionGoal.registerProjectileGoal(vault, mob));
        }
        HashSet appliedOverrides = new HashSet();
        ModConfigs.CHAMPIONS.entityAttributeOverrides.forEach((predicate, overrides) -> {
            if (predicate.test((Entity)entity)) {
                overrides.forEach(override -> {
                    ChampionPromoter.applyOverride(entity, override);
                    appliedOverrides.add(override.NAME);
                });
            }
        });
        ModConfigs.CHAMPIONS.defaultAttributeOverrides.forEach(attributeOverride -> {
            if (!appliedOverrides.contains(attributeOverride.NAME)) {
                ChampionPromoter.applyOverride(entity, attributeOverride);
            }
        });
        entity.m_21153_(1.0f);
        entity.m_5634_(1000000.0f);
    }

    private static void applyOverride(LivingEntity entity, ChampionsConfig.AttributeOverride override) {
        Registry.f_122866_.m_6612_(new ResourceLocation(override.NAME)).ifPresent(attribute -> {
            AttributeInstance instance = entity.m_21051_(attribute);
            if (instance == null) {
                return;
            }
            override.applyTo(instance);
        });
    }
}

