/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.champion;

import iskallia.vault.entity.champion.ChampionAffixBase;
import iskallia.vault.entity.champion.IChampionOnHitAffix;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class OnHitApplyPotionAffix
extends ChampionAffixBase
implements IChampionOnHitAffix {
    public static final String TYPE = "on_hit_apply_potion";
    @Nullable
    private final MobEffect mobEffect;
    private final int duration;
    private final int amplifier;
    private final float chance;

    public OnHitApplyPotionAffix(String name, @Nullable MobEffect mobEffect, int duration, int amplifier, float chance) {
        super(TYPE, name);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.chance = chance;
    }

    @Nullable
    public MobEffect getMobEffect() {
        return this.mobEffect;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag ret = super.serialize();
        if (this.mobEffect == null) {
            return ret;
        }
        ret.m_128359_("mob_effect", this.mobEffect.getRegistryName().toString());
        ret.m_128405_("duration", this.duration);
        ret.m_128405_("amplifier", this.amplifier);
        ret.m_128350_("chance", this.chance);
        return ret;
    }

    public static OnHitApplyPotionAffix deserialize(CompoundTag tag) {
        return new OnHitApplyPotionAffix(OnHitApplyPotionAffix.deserializeName(tag), (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(tag.m_128461_("mob_effect"))), tag.m_128451_("duration"), tag.m_128451_("amplifier"), tag.m_128457_("chance"));
    }

    @Override
    public void onChampionHitPlayer(LivingEntity champion, Player player, float amount) {
        if (this.mobEffect == null || player.m_21187_().nextFloat() > this.chance) {
            return;
        }
        player.m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier));
    }
}

