/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.champion;

import iskallia.vault.entity.champion.ChampionAffixBase;
import iskallia.vault.entity.champion.IChampionTickableAffix;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionAuraAffix
extends ChampionAffixBase
implements IChampionTickableAffix {
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(64.0);
    private static final int CHECK_COOLDOWN = 5;
    public static final String TYPE = "potion_aura";
    @Nullable
    private final MobEffect mobEffect;
    private final int duration;
    private final int amplifier;
    private final int range;
    private final Target target;
    private long cooldownTime = -1L;

    public PotionAuraAffix(String name, @Nullable MobEffect mobEffect, int duration, int amplifier, int range, Target target) {
        super(TYPE, name);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.range = range;
        this.target = target;
    }

    @Nullable
    public MobEffect getMobEffect() {
        return this.mobEffect;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (this.mobEffect == null || entity.m_183503_().m_5776_() || this.cooldownTime > entity.m_183503_().m_46467_()) {
            return;
        }
        this.cooldownTime = entity.m_183503_().m_46467_() + 5L;
        if (this.target == Target.PLAYER) {
            entity.m_183503_().m_45955_(TARGETING_CONDITIONS, entity, entity.m_142469_().m_82400_((double)this.range)).forEach(player -> player.m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier)));
        } else if (this.target == Target.MOB) {
            entity.m_183503_().m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), entity.m_142469_().m_82400_((double)this.range), e -> e != entity && !(e instanceof Player)).forEach(mob -> mob.m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier, true, false)));
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag ret = super.serialize();
        if (this.mobEffect == null) {
            return ret;
        }
        ret.m_128359_("mob_effect", this.mobEffect.getRegistryName().toString());
        ret.m_128405_("duration", this.duration);
        ret.m_128405_("amplifier", this.amplifier);
        ret.m_128405_("range", this.range);
        ret.m_128359_("target", this.target.name().toLowerCase(Locale.ROOT));
        return ret;
    }

    public static PotionAuraAffix deserialize(CompoundTag tag) {
        return new PotionAuraAffix(PotionAuraAffix.deserializeName(tag), (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(tag.m_128461_("mob_effect"))), tag.m_128451_("duration"), tag.m_128451_("amplifier"), tag.m_128451_("range"), Target.valueOf(tag.m_128461_("target").toUpperCase(Locale.ROOT)));
    }

    public static enum Target {
        PLAYER,
        MOB;

    }
}

