/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.init.ModEntities;
import iskallia.vault.util.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class DrillArrowEntity
extends Arrow {
    private int maxBreakCount = 0;
    private int breakCount = 0;
    private boolean doBreak = true;

    public DrillArrowEntity(EntityType<? extends DrillArrowEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public DrillArrowEntity(Level worldIn, double x, double y, double z) {
        this(ModEntities.DRILL_ARROW, worldIn);
        this.m_6034_(x, y, z);
    }

    public DrillArrowEntity(Level worldIn, LivingEntity shooter) {
        this(worldIn, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public DrillArrowEntity setMaxBreakCount(int maxBreakCount) {
        this.maxBreakCount = maxBreakCount;
        return this;
    }

    public void m_8119_() {
        if (this.doBreak && !this.m_20193_().m_5776_()) {
            this.aoeBreak();
        }
        if (this.m_20193_().m_5776_()) {
            this.playEffects();
        }
        super.m_8119_();
    }

    private void playEffects() {
        Vec3 vec = this.m_20182_();
        for (int i = 0; i < 5; ++i) {
            Vec3 v = vec.m_82520_((double)(this.f_19796_.nextFloat() * 0.4f * (float)(this.f_19796_.nextBoolean() ? 1 : -1)), (double)(this.f_19796_.nextFloat() * 0.4f * (float)(this.f_19796_.nextBoolean() ? 1 : -1)), (double)(this.f_19796_.nextFloat() * 0.4f * (float)(this.f_19796_.nextBoolean() ? 1 : -1)));
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private void aoeBreak() {
        Entity shooter = this.m_37282_();
        if (!(shooter instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)shooter;
        Level world = this.m_20193_();
        float vel = (float)this.m_20184_().m_82553_();
        for (BlockPos offset : BlockHelper.getSpherePositions(this.m_142538_(), Math.max(4.5f, 4.5f * vel))) {
            float hardness;
            if (this.breakCount >= this.maxBreakCount) break;
            BlockState state = world.m_8055_(offset);
            if (state.m_60795_() || state.m_60834_() && !state.m_204336_(BlockTags.f_144285_) || !((hardness = state.m_60800_((BlockGetter)world, offset)) >= 0.0f) || !(hardness <= 25.0f) || !this.destroyBlock(world, offset, state, player)) continue;
            ++this.breakCount;
        }
    }

    private boolean destroyBlock(Level world, BlockPos pos, BlockState state, ServerPlayer player) {
        ItemStack miningItem = new ItemStack((ItemLike)Items.f_42390_);
        Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), null, (ItemStack)miningItem);
        return state.onDestroyedByPlayer(world, pos, (Player)player, true, state.m_60819_());
    }

    protected void m_6532_(HitResult result) {
        if (result instanceof BlockHitResult && this.breakCount < this.maxBreakCount && !this.m_20193_().m_5776_()) {
            this.aoeBreak();
        }
        if (this.breakCount >= this.maxBreakCount) {
            this.doBreak = false;
            super.m_6532_(result);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.doBreak = compound.m_128471_("break");
        this.breakCount = compound.m_128451_("breakCount");
        this.maxBreakCount = compound.m_128451_("maxBreakCount");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("break", this.doBreak);
        compound.m_128405_("breakCount", this.breakCount);
        compound.m_128405_("maxBreakCount", this.maxBreakCount);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

