/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.Expose;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModParticles;
import iskallia.vault.world.data.VaultPartyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectCloudEntity
extends Entity {
    private static final Logger PRIVATE_LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(EffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IGNORE_RADIUS = SynchedEntityData.m_135353_(EffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> PARTICLE = SynchedEntityData.m_135353_(EffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private Potion potion = Potions.f_43598_;
    private final List<MobEffectInstance> effects = Lists.newArrayList();
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean affectsOwner = true;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUniqueId;

    public EffectCloudEntity(EntityType<? extends EffectCloudEntity> cloud, Level world) {
        super(cloud, world);
        this.f_19794_ = true;
        this.setRadius(3.0f);
    }

    public EffectCloudEntity(Level world, double x, double y, double z) {
        this(ModEntities.EFFECT_CLOUD, world);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(COLOR, (Object)0);
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(IGNORE_RADIUS, (Object)false);
        this.m_20088_().m_135372_(PARTICLE, (Object)((ParticleOptions)ModParticles.CLOUD_EFFECT.get()));
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float radiusIn) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void setPotion(Potion potionIn) {
        this.potion = potionIn;
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    private void updateFixedColor() {
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.m_20088_().m_135381_(COLOR, (Object)0);
        } else {
            this.m_20088_().m_135381_(COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance effect) {
        this.effects.add(effect);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setColor(int colorIn) {
        this.colorSet = true;
        this.m_20088_().m_135381_(COLOR, (Object)colorIn);
    }

    public boolean affectsOwner() {
        return this.affectsOwner;
    }

    public void setAffectsOwner(boolean affectsOwner) {
        this.affectsOwner = affectsOwner;
    }

    public ParticleOptions getParticleData() {
        return (ParticleOptions)this.m_20088_().m_135370_(PARTICLE);
    }

    public void setParticleData(ParticleOptions particleData) {
        this.m_20088_().m_135381_(PARTICLE, (Object)particleData);
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.m_20088_().m_135381_(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.m_20088_().m_135370_(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void m_7311_(int seconds) {
        super.m_7311_(0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.tickParticles();
        } else {
            boolean flag1;
            boolean ignoreRadius = this.shouldIgnoreRadius();
            float radius = this.getRadius();
            if (this.f_19797_ >= this.waitTime + this.duration) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            boolean bl = flag1 = this.f_19797_ < this.waitTime;
            if (ignoreRadius != flag1) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.5f) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                this.setRadius(radius);
            }
            if (this.f_19797_ % 5 == 0) {
                this.reapplicationDelayMap.entrySet().removeIf(entry -> this.f_19797_ >= (Integer)entry.getValue());
                ArrayList effectsToApply = Lists.newArrayList();
                for (MobEffectInstance effect : this.potion.m_43488_()) {
                    effectsToApply.add(new MobEffectInstance(effect.m_19544_(), effect.m_19557_() / 4, effect.m_19564_(), effect.m_19571_(), effect.m_19572_()));
                }
                effectsToApply.addAll(this.effects);
                if (effectsToApply.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List entitiesInRadius = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_());
                    if (!entitiesInRadius.isEmpty()) {
                        for (LivingEntity livingentity : entitiesInRadius) {
                            double zDiff;
                            double xDiff;
                            double distance;
                            if (!this.canApplyEffects(livingentity) || this.reapplicationDelayMap.containsKey(livingentity) || !livingentity.m_5801_() || !((distance = (xDiff = livingentity.m_20185_() - this.m_20185_()) * xDiff + (zDiff = livingentity.m_20189_() - this.m_20189_()) * zDiff) <= (double)(radius * radius))) continue;
                            this.reapplicationDelayMap.put((Entity)livingentity, this.f_19797_ + this.reapplicationDelay);
                            for (MobEffectInstance effectinstance : effectsToApply) {
                                if (effectinstance.m_19544_().m_8093_()) {
                                    ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> effectinstance.m_19544_().m_19461_((Entity)this, (Entity)this.getOwner(), livingentity, effectinstance.m_19564_(), 0.5));
                                    continue;
                                }
                                livingentity.m_7292_(new MobEffectInstance(effectinstance));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((radius += this.radiusOnUse) < 0.5f) {
                                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                                    return;
                                }
                                this.setRadius(radius);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.m_142687_(Entity.RemovalReason.DISCARDED);
                            return;
                        }
                    }
                }
            }
        }
    }

    private void tickParticles() {
        block7: {
            ParticleOptions iparticledata;
            float radius;
            block6: {
                boolean ignoreRadius = this.shouldIgnoreRadius();
                radius = this.getRadius();
                iparticledata = this.getParticleData();
                if (!ignoreRadius) break block6;
                if (!this.f_19796_.nextBoolean()) break block7;
                for (int i = 0; i < 2; ++i) {
                    float randomRad = this.f_19796_.nextFloat() * ((float)Math.PI * 2);
                    float randomDst = Mth.m_14116_((float)this.f_19796_.nextFloat()) * 0.2f;
                    float xOffset = Mth.m_14089_((float)randomRad) * randomDst;
                    float zOffset = Mth.m_14031_((float)randomRad) * randomDst;
                    if (this.f_19796_.nextInt(25) != 0) continue;
                    if (iparticledata.m_6012_() == ParticleTypes.f_123811_ || iparticledata.m_6012_() == ModParticles.CLOUD_EFFECT.get()) {
                        int color = this.f_19796_.nextBoolean() ? 0xFFFFFF : this.getColor();
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        this.f_19853_.m_7107_(iparticledata, this.m_20185_() + (double)xOffset, this.m_20186_(), this.m_20189_() + (double)zOffset, (double)((float)r / 255.0f), (double)((float)g / 255.0f), (double)((float)b / 255.0f));
                        continue;
                    }
                    this.f_19853_.m_7107_(iparticledata, this.m_20185_() + (double)xOffset, this.m_20186_(), this.m_20189_() + (double)zOffset, 0.0, 0.0, 0.0);
                }
                break block7;
            }
            float distance = (float)Math.PI * radius * radius;
            int i = 0;
            while ((float)i < distance) {
                float randomRad = this.f_19796_.nextFloat() * ((float)Math.PI * 2);
                float randomDst = Mth.m_14116_((float)this.f_19796_.nextFloat()) * radius;
                float xOffset = Mth.m_14089_((float)randomRad) * randomDst;
                float zOffset = Mth.m_14031_((float)randomRad) * randomDst;
                if (this.f_19796_.nextInt(25) == 0) {
                    if (iparticledata.m_6012_() == ParticleTypes.f_123811_ || iparticledata.m_6012_() == ModParticles.CLOUD_EFFECT.get()) {
                        int color = this.getColor();
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        this.f_19853_.m_7107_(iparticledata, this.m_20185_() + (double)xOffset, this.m_20186_(), this.m_20189_() + (double)zOffset, (double)((float)r / 255.0f), (double)((float)g / 255.0f), (double)((float)b / 255.0f));
                    } else {
                        this.f_19853_.m_7107_(iparticledata, this.m_20185_() + (double)xOffset, this.m_20186_(), this.m_20189_() + (double)zOffset, (0.5 - this.f_19796_.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.f_19796_.nextDouble()) * 0.15);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean canApplyEffects(LivingEntity target) {
        if (!this.affectsOwner()) {
            TamableAnimal tamable;
            VaultPartyData.Party party;
            if (this.ownerUniqueId == null) {
                return true;
            }
            UUID targetUUID = target.m_142081_();
            if (targetUUID.equals(this.ownerUniqueId)) {
                return false;
            }
            UUID ownerUUID = this.ownerUniqueId;
            Level world = this.m_20193_();
            if (!(world instanceof ServerLevel)) {
                return true;
            }
            ServerLevel sWorld = (ServerLevel)world;
            LivingEntity owner = this.getOwner();
            if (owner instanceof EternalEntity) {
                UUID eternalOwnerUUID = (UUID)((EternalEntity)owner).getOwner().map(Function.identity(), Entity::m_142081_);
                if (targetUUID.equals(eternalOwnerUUID)) {
                    return false;
                }
                party = VaultPartyData.get(sWorld).getParty(eternalOwnerUUID).orElse(null);
                if (party != null && party.hasMember(targetUUID)) {
                    return false;
                }
                ownerUUID = eternalOwnerUUID;
            }
            if (target instanceof EternalEntity) {
                UUID eternalTargetOwnerUUID = (UUID)((EternalEntity)target).getOwner().map(Function.identity(), Entity::m_142081_);
                if (eternalTargetOwnerUUID.equals(ownerUUID)) {
                    return false;
                }
                party = VaultPartyData.get(sWorld).getParty(eternalTargetOwnerUUID).orElse(null);
                if (party != null && party.hasMember(ownerUUID)) {
                    return false;
                }
            }
            if (target instanceof TamableAnimal && ownerUUID.equals((tamable = (TamableAnimal)target).m_142504_())) {
                return false;
            }
            VaultPartyData.Party party2 = VaultPartyData.get(sWorld).getParty(ownerUUID).orElse(null);
            if (party2 != null && party2.hasMember(targetUUID)) {
                return false;
            }
        }
        return true;
    }

    public void setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    public void setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.m_142081_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19797_ = compound.m_128451_("Age");
        this.duration = compound.m_128451_("Duration");
        this.waitTime = compound.m_128451_("WaitTime");
        this.reapplicationDelay = compound.m_128451_("ReapplicationDelay");
        this.durationOnUse = compound.m_128451_("DurationOnUse");
        this.radiusOnUse = compound.m_128457_("RadiusOnUse");
        this.radiusPerTick = compound.m_128457_("RadiusPerTick");
        this.setRadius(compound.m_128457_("Radius"));
        if (compound.m_128403_("Owner")) {
            this.ownerUniqueId = compound.m_128342_("Owner");
        }
        if (compound.m_128425_("Particle", 8)) {
            try {
                this.setParticleData(ParticleArgument.m_103944_((StringReader)new StringReader(compound.m_128461_("Particle"))));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                PRIVATE_LOGGER.warn("Couldn't load custom particle {}", (Object)compound.m_128461_("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (compound.m_128425_("Color", 99)) {
            this.setColor(compound.m_128451_("Color"));
        }
        if (compound.m_128425_("Potion", 8)) {
            this.setPotion(PotionUtils.m_43577_((CompoundTag)compound));
        }
        if (compound.m_128425_("Effects", 9)) {
            ListTag listnbt = compound.m_128437_("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listnbt.size(); ++i) {
                MobEffectInstance effectinstance = MobEffectInstance.m_19560_((CompoundTag)listnbt.m_128728_(i));
                if (effectinstance == null) continue;
                this.addEffect(effectinstance);
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Age", this.f_19797_);
        compound.m_128405_("Duration", this.duration);
        compound.m_128405_("WaitTime", this.waitTime);
        compound.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        compound.m_128405_("DurationOnUse", this.durationOnUse);
        compound.m_128350_("RadiusOnUse", this.radiusOnUse);
        compound.m_128350_("RadiusPerTick", this.radiusPerTick);
        compound.m_128350_("Radius", this.getRadius());
        compound.m_128359_("Particle", this.getParticleData().m_5942_());
        if (this.ownerUniqueId != null) {
            compound.m_128362_("Owner", this.ownerUniqueId);
        }
        if (this.colorSet) {
            compound.m_128405_("Color", this.getColor());
        }
        if (this.potion != Potions.f_43598_ && this.potion != null) {
            compound.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("Effects", (Tag)listnbt);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (RADIUS.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }

    public static EffectCloudEntity fromConfig(Level world, LivingEntity owner, double x, double y, double z, Config config) {
        EffectCloudEntity cloud = new EffectCloudEntity(world, x, y, z);
        cloud.setPotion(config.getPotion());
        config.getEffects().forEach(effect -> cloud.addEffect(effect.create()));
        if (config.getDuration() >= 0) {
            cloud.setDuration(config.getDuration());
        }
        if (config.getRadius() >= 0.0f) {
            cloud.setRadius(config.getRadius());
        }
        if (config.getColor() >= 0) {
            cloud.setColor(config.getColor());
        }
        cloud.setAffectsOwner(config.affectsOwner());
        cloud.setOwner(owner);
        return cloud;
    }

    public static class Config
    implements INBTSerializable<CompoundTag> {
        @Expose
        private String name;
        @Expose
        private String potion;
        @Expose
        private List<CloudEffect> effects;
        @Expose
        private int duration;
        @Expose
        private float radius;
        @Expose
        private int color;
        @Expose
        private boolean affectsOwner;
        @Expose
        private float chance;

        public String toString() {
            return "Config{name='" + this.name + "', potion='" + this.potion + "', effects=" + this.effects + "}";
        }

        public Config() {
            this("Dummy", Potions.f_43598_, new ArrayList<CloudEffect>(), 600, 3.0f, -1, true, 1.0f);
        }

        public Config(String name, Potion potion, List<CloudEffect> effects, int duration, float radius, int color, boolean affectsOwner, float chance) {
            this.name = name;
            this.potion = potion.getRegistryName().toString();
            this.effects = effects;
            this.duration = duration;
            this.radius = radius;
            this.color = color;
            this.affectsOwner = affectsOwner;
            this.chance = chance;
        }

        public static Config fromNBT(CompoundTag nbt) {
            Config config = new Config();
            config.deserializeNBT(nbt);
            return config;
        }

        public String getName() {
            return this.name;
        }

        public Potion getPotion() {
            return Registry.f_122828_.m_6612_(new ResourceLocation(this.potion)).orElse(Potions.f_43598_);
        }

        public List<CloudEffect> getEffects() {
            return this.effects;
        }

        public int getDuration() {
            return this.duration;
        }

        public float getRadius() {
            return this.radius;
        }

        public int getColor() {
            return this.color;
        }

        public boolean affectsOwner() {
            return this.affectsOwner;
        }

        public float getChance() {
            return this.chance;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Name", this.name);
            nbt.m_128359_("Potion", this.potion);
            ListTag effectsList = new ListTag();
            this.effects.forEach(cloudEffect -> effectsList.add((Object)cloudEffect.serializeNBT()));
            nbt.m_128365_("Effects", (Tag)effectsList);
            nbt.m_128405_("Duration", this.duration);
            nbt.m_128350_("Radius", this.radius);
            nbt.m_128405_("Color", this.color);
            nbt.m_128379_("AffectsOwner", this.affectsOwner);
            nbt.m_128350_("Chance", this.chance);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.name = nbt.m_128461_("Name");
            this.potion = nbt.m_128461_("Potion");
            ListTag effectsList = nbt.m_128437_("Effects", 10);
            this.effects = effectsList.stream().map(inbt -> CloudEffect.fromNBT((CompoundTag)inbt)).collect(Collectors.toList());
            this.duration = nbt.m_128451_("Duration");
            this.radius = nbt.m_128457_("Radius");
            this.color = nbt.m_128451_("Color");
            this.affectsOwner = nbt.m_128471_("AffectsOwner");
            this.chance = nbt.m_128457_("Chance");
        }

        public static class CloudEffect
        implements INBTSerializable<CompoundTag> {
            @Expose
            private String effect;
            @Expose
            private int duration;
            @Expose
            private int amplifier;
            @Expose
            private boolean showParticles;
            @Expose
            private boolean showIcon;

            protected CloudEffect() {
            }

            public CloudEffect(MobEffect effect, int duration, int amplifier, boolean showParticles, boolean showIcon) {
                this.effect = effect.getRegistryName().toString();
                this.duration = duration;
                this.amplifier = amplifier;
                this.showParticles = false;
                this.showIcon = true;
            }

            public static CloudEffect fromNBT(CompoundTag nbt) {
                CloudEffect effect = new CloudEffect();
                effect.deserializeNBT(nbt);
                return effect;
            }

            public MobEffect getEffect() {
                return (MobEffect)Registry.f_122823_.m_7745_(new ResourceLocation(this.effect));
            }

            public int getDuration() {
                return this.duration;
            }

            public int getAmplifier() {
                return this.amplifier;
            }

            public boolean showParticles() {
                return this.showParticles;
            }

            public boolean showIcon() {
                return this.showIcon;
            }

            public MobEffectInstance create() {
                return new MobEffectInstance(this.getEffect(), this.getDuration(), this.getAmplifier(), false, this.showParticles(), this.showIcon());
            }

            public CompoundTag serializeNBT() {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("Effect", this.effect);
                nbt.m_128405_("Duration", this.duration);
                nbt.m_128405_("Amplifier", this.amplifier);
                nbt.m_128379_("ShowParticles", this.showParticles);
                nbt.m_128379_("ShowIcon", this.showIcon);
                return nbt;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.effect = nbt.m_128461_("Effect");
                this.duration = nbt.m_128451_("Duration");
                this.amplifier = nbt.m_128451_("Amplifier");
                this.showParticles = nbt.m_128471_("ShowParticles");
                this.showIcon = nbt.m_128471_("ShowIcon");
            }
        }
    }
}

