/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.ai.ThrowProjectilesGoal;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.FighterSizeMessage;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.SkinProfile;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldSettings;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class FighterEntity
extends Zombie {
    public static final ThrowProjectilesGoal.Projectile SNOWBALLS = (world1, shooter) -> new Snowball(world1, shooter){

        protected void m_5790_(EntityHitResult raycast) {
            Entity entity = raycast.m_82443_();
            if (entity == shooter) {
                return;
            }
            int i = entity instanceof Blaze ? 3 : 1;
            entity.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)shooter), (float)i);
        }
    };
    public SkinProfile skin;
    public String lastName = "Fighter";
    public float sizeMultiplier = 1.0f;
    public ServerBossEvent bossInfo;

    public FighterEntity(EntityType<? extends Zombie> type, Level world) {
        super(type, world);
        if (!this.f_19853_.f_46443_) {
            this.changeSize(this.sizeMultiplier);
            this.m_21051_(Attributes.f_22279_).m_22100_((double)this.f_19796_.nextFloat() * 0.15 + 0.2);
        } else {
            this.skin = new SkinProfile();
        }
        this.bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        this.bossInfo.m_7003_(true);
        this.bossInfo.m_8321_(false);
        this.m_6593_((Component)new TextComponent(this.lastName));
        this.m_21530_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        ServerVaults.get(this.f_19853_).ifPresent(this::registerProjectileGoal);
        super.m_8099_();
    }

    private void registerProjectileGoal(Vault vault) {
        VaultDifficulty vaultDifficulty = WorldSettings.get(this.f_19853_).getPlayerDifficulty(vault.get(Vault.OWNER));
        if (vaultDifficulty.shouldAddAntiNerdPoleAi()) {
            this.f_21345_.m_25352_(3, (Goal)new ThrowProjectilesGoal<FighterEntity>(this, ModConfigs.FIGHTER.chancerPerTick, 1, ThrowableBrick::new){

                @Override
                public void m_8056_() {
                    super.m_8056_();
                    ((FighterEntity)((Object)this.getEntity())).m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42460_));
                }

                @Override
                public boolean m_8036_() {
                    return super.m_8036_() && this.targetOutOfReachAbove();
                }

                @Override
                public boolean m_8045_() {
                    return super.m_8045_() && this.targetOutOfReachAbove();
                }

                private boolean targetOutOfReachAbove() {
                    LivingEntity target = FighterEntity.this.m_5448_();
                    if (target == null) {
                        return false;
                    }
                    double targetDistance = FighterEntity.this.m_20280_((Entity)target);
                    double attackReach = this.getAttackReachSqr(target);
                    double yDiff = target.m_20186_() - FighterEntity.this.m_20186_();
                    return targetDistance > attackReach && targetDistance < attackReach * 16.0 && yDiff >= 2.0 && yDiff <= 4.0;
                }

                private double getAttackReachSqr(LivingEntity pAttackTarget) {
                    return FighterEntity.this.m_20205_() * 2.0f * FighterEntity.this.m_20205_() * 2.0f + pAttackTarget.m_20205_();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasSkin() {
        return !this.skin.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSlimSkin() {
        return this.skin.isSlim();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getLocationSkin() {
        return this.skin.getLocationSkin();
    }

    public boolean m_6162_() {
        return false;
    }

    protected boolean m_5884_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_20890_) {
            return;
        }
        if (this.f_19853_.f_46443_) {
            String name = this.m_7770_().getString();
            String star = String.valueOf('\u2726');
            while (name.startsWith(star)) {
                name = name.substring(1);
            }
            if ((name = name.trim()).startsWith("[")) {
                String[] data = name.split(Pattern.quote("]"));
                name = data[1].trim();
            }
            if (!this.lastName.equals(name)) {
                this.skin.updateSkin(name);
                this.lastName = name;
            }
        } else {
            double amplitude = this.m_20184_().m_82531_(0.0, this.m_20184_().m_7098_(), 0.0);
            if (amplitude > 0.004) {
                this.m_6858_(true);
            } else {
                this.m_6858_(false);
            }
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12323_;
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("SizeMultiplier", this.sizeMultiplier);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("SizeMultiplier", 5)) {
            this.changeSize(compound.m_128457_("SizeMultiplier"));
        }
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.f_19815_;
    }

    public float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public FighterEntity changeSize(float m) {
        this.sizeMultiplier = m;
        EntityHelper.changeSize(this, this.sizeMultiplier);
        if (!this.f_19853_.m_5776_()) {
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new FighterSizeMessage((Entity)this, this.sizeMultiplier));
        }
        return this;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.sizeMultiplier;
    }

    protected void m_7595_() {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        this.m_6593_(this.m_7770_());
        this.m_34336_(true);
        this.m_21553_(true);
        this.m_21530_();
        if (this.f_19796_.nextInt(100) == 0) {
            Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(this.f_19853_);
            chicken.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            chicken.m_6518_(world, difficulty, reason, spawnData, dataTag);
            chicken.m_28273_(true);
            ((ServerLevel)this.f_19853_).m_8847_((Entity)chicken);
            this.m_20329_((Entity)chicken);
        }
        return spawnData;
    }

    protected void m_7625_(DamageSource damageSource, boolean attackedRecently) {
        super.m_7625_(damageSource, attackedRecently);
        if (this.f_19853_.m_5776_()) {
            return;
        }
    }

    public boolean m_7327_(Entity entity) {
        if (!this.f_19853_.f_46443_) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, this.f_19796_.nextFloat() - this.f_19796_.nextFloat());
        }
        return super.m_7327_(entity);
    }

    public static class ThrowableBrick
    extends ThrowableItemProjectile {
        @Nullable
        private LivingEntity thrower;

        public ThrowableBrick(EntityType<ThrowableBrick> entityType, Level level) {
            super(entityType, level);
        }

        public ThrowableBrick(Level level, LivingEntity thrower) {
            super(ModEntities.BRICK, thrower, level);
            this.thrower = thrower;
        }

        protected Item m_7881_() {
            return Items.f_42460_;
        }

        protected void m_5790_(EntityHitResult result) {
            if (this.f_19853_.m_5776_()) {
                return;
            }
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.thrower == null) {
                    this.m_146870_();
                    return;
                }
                double xRatio = this.thrower.m_20185_() - livingEntity.m_20185_();
                double zRatio = this.thrower.m_20189_() - livingEntity.m_20189_();
                while (xRatio * xRatio + zRatio * zRatio < 1.0E-4) {
                    xRatio = (Math.random() - Math.random()) * 0.01;
                    zRatio = (Math.random() - Math.random()) * 0.01;
                }
                livingEntity.f_19864_ = true;
                livingEntity.m_147240_(ModConfigs.FIGHTER.knockback, xRatio, zRatio);
            }
        }
    }
}

