/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.client.particles.FloatingAltarItemParticle;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class FloatingGodAltarItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<Integer> COLOR1 = SynchedEntityData.m_135353_(FloatingGodAltarItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR2 = SynchedEntityData.m_135353_(FloatingGodAltarItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int color1 = 0;
    private int color2 = 0;

    public FloatingGodAltarItemEntity(EntityType<? extends ItemEntity> type, Level world) {
        super(type, world);
    }

    public FloatingGodAltarItemEntity(Level worldIn, double x, double y, double z) {
        this(ModEntities.FLOATING_ALTAR_ITEM, worldIn);
        this.m_6034_(x, y, z);
        this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
        this.m_20334_(this.f_19796_.nextDouble() * 0.2 - 0.1, 0.2, this.f_19796_.nextDouble() * 0.2 - 0.1);
    }

    public FloatingGodAltarItemEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.m_32045_(stack);
        this.lifespan = Integer.MAX_VALUE;
    }

    public static FloatingGodAltarItemEntity create(Level world, BlockPos pos, ItemStack stack) {
        return new FloatingGodAltarItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR1, (Object)0xFFFFFF);
        this.m_20088_().m_135372_(COLOR2, (Object)0xFFFFFF);
    }

    public FloatingGodAltarItemEntity setColor(int color) {
        this.setColor(color, color);
        this.color1 = color;
        this.color2 = color;
        return this;
    }

    public boolean m_20223_(CompoundTag pCompound) {
        pCompound.m_128405_("color1", this.color1);
        pCompound.m_128405_("color2", this.color2);
        return super.m_20223_(pCompound);
    }

    public void m_20258_(CompoundTag pCompound) {
        this.setColor(pCompound.m_128451_("color1"), pCompound.m_128451_("color2"));
        super.m_20258_(pCompound);
    }

    public FloatingGodAltarItemEntity setColor(int color1, int color2) {
        this.f_19804_.m_135381_(COLOR1, (Object)color1);
        this.f_19804_.m_135381_(COLOR2, (Object)color2);
        this.color1 = color1;
        this.color2 = color2;
        return this;
    }

    public void m_8119_() {
        this.m_20256_(Vec3.f_82478_);
        super.m_8119_();
        if (this.m_6084_() && this.f_19853_.m_5776_()) {
            this.playEffects();
        }
    }

    public void m_6478_(MoverType type, Vec3 velocity) {
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_(3.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        int color1 = (Integer)this.m_20088_().m_135370_(COLOR1);
        int color2 = (Integer)this.m_20088_().m_135370_(COLOR2);
        Particle particle = mgr.m_107370_((ParticleOptions)ModParticles.FLOATING_ALTAR_ITEM.get(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_() + 0.25, this.m_20182_().m_7094_(), 0.25, (double)(this.f_19797_ % 360), 0.0);
        if (particle instanceof FloatingAltarItemParticle) {
            FloatingAltarItemParticle floatingAltarItemParticle = (FloatingAltarItemParticle)particle;
            floatingAltarItemParticle.setEntity((Entity)this);
            int col = ColorUtil.blendColors(color1, color2, this.f_19796_.nextFloat());
            float b = (float)(col & 0xFF) / 255.0f;
            float g = (float)(col >> 8 & 0xFF) / 255.0f;
            float r = (float)(col >> 16 & 0xFF) / 255.0f;
            particle.m_107253_(r, g, b);
        }
    }

    public void m_6123_(Player player) {
        boolean wasAlive = this.m_6084_();
        super.m_6123_(player);
        if (wasAlive && !this.m_6084_()) {
            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.6f, 1.0f);
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

