/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.init.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TreasureGoblinEntity
extends Monster {
    protected int disappearTick;
    protected boolean shouldDisappear;
    protected Player lastAttackedPlayer;

    public TreasureGoblinEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, (double)1.7f, 2.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isHitByPlayer() {
        return this.lastAttackedPlayer != null;
    }

    protected int calcDisappearTicks(Player player) {
        return 200;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!entity.f_19853_.f_46443_ && !this.isHitByPlayer()) {
                this.lastAttackedPlayer = player;
                this.disappearTick = this.calcDisappearTicks(player);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, this.disappearTick));
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            Level level;
            if (this.isHitByPlayer()) {
                if (this.disappearTick <= 0) {
                    this.shouldDisappear = true;
                }
                --this.disappearTick;
            }
            if ((level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.shouldDisappear) {
                    this.disappear(serverLevel);
                }
            }
        }
    }

    public void disappear(ServerLevel world) {
        this.m_142467_(Entity.RemovalReason.DISCARDED);
        if (this.lastAttackedPlayer != null) {
            TextComponent bailText = (TextComponent)new TextComponent("Treasure Goblin escaped from you.").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)8042883)));
            this.lastAttackedPlayer.m_5661_((Component)bailText, true);
            this.lastAttackedPlayer.m_6330_(ModSounds.GOBLIN_BAIL, SoundSource.MASTER, 0.7f, 1.0f);
            world.m_6263_(this.lastAttackedPlayer, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.GOBLIN_BAIL, SoundSource.MASTER, 0.7f, 1.0f);
        } else {
            world.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.GOBLIN_BAIL, SoundSource.MASTER, 0.7f, 1.0f);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return ModSounds.GOBLIN_IDLE;
    }

    public SoundEvent m_5592_() {
        return ModSounds.GOBLIN_DEATH;
    }

    public SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return ModSounds.GOBLIN_HURT;
    }
}

