/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.StonefallFrostParticleMessage;
import iskallia.vault.util.effect.ScheduledEffectHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class VaultBlizzardShard
extends AbstractArrow {
    private boolean grounded;
    private boolean hitTarget;
    private int life;
    public Vec3 prevDeltaMovement = new Vec3(0.0, 0.0, 0.0);
    private boolean leftOwner;
    private boolean hasBeenShot;
    private int slowDuration;
    private int frostbiteDuration;
    private int amplifier;
    private int intervalHypothermiaTicks;
    private float frostbiteChance;
    private LivingEntity entityLocked = null;
    private static final String TAG_INTERVAL_TICKS = "intervalTicks";
    private static final String TAG_REMAINING_INTERVAL_TICKS = "remainingIntervalTicks";
    private static final String TAG_PLAYER_UUID = "playerUUID";
    private static final String TAG_ABILITY_DATA = "the_vault:ability/Nova_Slow";

    public VaultBlizzardShard(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public byte m_36796_() {
        return 0;
    }

    private boolean shouldFall() {
        return this.f_36703_ && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    public void setEntityLocked(LivingEntity entityLocked) {
        this.entityLocked = entityLocked;
    }

    private void startFalling() {
        this.f_36703_ = false;
        Vec3 vec3 = this.m_20184_();
        this.life = 0;
    }

    private boolean checkLeftOwner() {
        Entity entity = this.m_37282_();
        if (entity != null) {
            for (Entity entity1 : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public void setSlowDuration(int slowDuration) {
        this.slowDuration = slowDuration;
    }

    public void setFrostbiteDuration(int frostbiteDuration) {
        this.frostbiteDuration = frostbiteDuration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setFrostbiteChance(float frostbiteChance) {
        this.frostbiteChance = frostbiteChance;
    }

    public void setIntervalHypothermiaTicks(int intervalHypothermiaTicks) {
        this.intervalHypothermiaTicks = intervalHypothermiaTicks;
    }

    public boolean m_20068_() {
        return super.m_20068_();
    }

    private int getSlowDuration() {
        return this.slowDuration;
    }

    public int getFrostbiteDuration() {
        return this.frostbiteDuration;
    }

    private int getAmplifier() {
        return this.amplifier;
    }

    private int getIntervalHypothermiaTicks() {
        return this.intervalHypothermiaTicks;
    }

    private float getFrostbiteChance() {
        return this.frostbiteChance;
    }

    private void destroy() {
        Entity entity;
        if (this.entityLocked != null && (entity = this.m_37282_()) instanceof Player) {
            Player player = (Player)entity;
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallFrostParticleMessage(this.entityLocked.m_20182_(), 2.0f));
            this.entityLocked.m_7292_(new MobEffectInstance(ModEffects.CHILLED, this.getSlowDuration(), this.getAmplifier()));
            CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data((LivingEntity)player, this.entityLocked));
            if (this.f_19796_.nextFloat() <= this.getFrostbiteChance()) {
                if (this.entityLocked.m_21023_(ModEffects.GLACIAL_SHATTER)) {
                    this.entityLocked.m_21195_(ModEffects.GLACIAL_SHATTER);
                }
                this.entityLocked.m_7292_(new MobEffectInstance(ModEffects.GLACIAL_SHATTER, this.getFrostbiteDuration(), this.getAmplifier()));
                this.m_183503_().m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.25f, 0.65f);
            } else {
                this.m_183503_().m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.15f, 0.75f);
            }
            if (!this.entityLocked.m_21023_((MobEffect)ModEffects.HYPOTHERMIA)) {
                ScheduledEffectHelper.invalidateAll(this.entityLocked, (MobEffect)ModEffects.HYPOTHERMIA);
                ScheduledEffectHelper.scheduleEffect(this.entityLocked, ModEffects.HYPOTHERMIA.instance(0, true), this.getSlowDuration());
                VaultBlizzardShard.setAbilityData(this.entityLocked, this.getIntervalHypothermiaTicks(), player.m_142081_());
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private static void setAbilityData(LivingEntity livingEntity, int intervalTicks, UUID playerUUID) {
        CompoundTag abilityData = VaultBlizzardShard.getAbilityData(livingEntity);
        abilityData.m_128405_(TAG_INTERVAL_TICKS, intervalTicks);
        abilityData.m_128405_(TAG_REMAINING_INTERVAL_TICKS, 0);
        abilityData.m_128362_(TAG_PLAYER_UUID, playerUUID);
    }

    private static CompoundTag getAbilityData(LivingEntity livingEntity) {
        CompoundTag persistentData = livingEntity.getPersistentData();
        CompoundTag abilityData = persistentData.m_128469_(TAG_ABILITY_DATA);
        persistentData.m_128365_(TAG_ABILITY_DATA, (Tag)abilityData);
        return abilityData;
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (this.f_36704_ > 4) {
            this.grounded = true;
        }
        if (this.f_19853_.m_5776_() && !this.grounded && this.f_19797_ > 2) {
            for (int i = 0; i < 2; ++i) {
                ParticleEngine pm = Minecraft.m_91087_().f_91061_;
                Particle particle = pm.m_107370_((ParticleOptions)ParticleTypes.f_175821_, this.m_20182_().f_82479_ + this.m_20184_().f_82479_ / (double)i, this.m_20182_().f_82480_ + this.m_20184_().f_82480_ / (double)i, this.m_20182_().f_82481_ + this.m_20184_().f_82481_ / (double)i, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.m_107253_(0.9f, 0.9f, 0.9f);
                    particle.m_6569_(0.75f);
                }
                if ((particle = pm.m_107370_((ParticleOptions)ParticleTypes.f_175821_, this.m_20182_().f_82479_ + this.m_20184_().f_82479_ / (double)i, this.m_20182_().f_82480_ + this.m_20184_().f_82480_ / (double)i, this.m_20182_().f_82481_ + this.m_20184_().f_82481_ / (double)i, 0.0, 0.0, 0.0)) == null) continue;
                particle.m_107253_(0.6f, 0.7f, 0.9f);
                particle.m_6569_(0.35f);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.entityLocked != null && !this.entityLocked.m_21224_()) {
                float f;
                if (!this.grounded) {
                    this.m_20256_(this.m_20184_().m_82520_((this.entityLocked.m_20182_().f_82479_ - this.m_20182_().f_82479_) * (double)0.02f, 0.0, (this.entityLocked.m_20182_().f_82481_ - this.m_20182_().f_82481_) * (double)0.02f));
                }
                if (this.hitTarget && (f = (float)(this.m_20182_().f_82480_ - this.entityLocked.m_20182_().f_82480_)) < 0.2f) {
                    this.destroy();
                }
                if (this.m_20182_().f_82480_ < this.entityLocked.m_20182_().f_82480_) {
                    this.destroy();
                }
            } else if (this.f_19797_ > 20) {
                this.destroy();
            }
        }
        this.prevDeltaMovement = this.m_20184_();
        this.m_6075_();
        if (!this.hasBeenShot) {
            this.m_146855_(GameEvent.f_157778_, this.m_37282_(), this.m_142538_());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_142538_())).m_60795_() || flag || !this.hitTarget && this.entityLocked != null || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.shouldFall()) {
                this.startFalling();
            } else if (!this.f_19853_.f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            Vec3 vec33;
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_146910_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(VaultBlizzardShard.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(VaultBlizzardShard.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            float f1 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f2 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.075f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
        }
    }

    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos, float radius) {
        AABB aabb = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        return world.m_45976_(LivingEntity.class, aabb);
    }

    protected void m_6532_(@NotNull HitResult result) {
        super.m_6532_(result);
    }

    protected boolean m_5603_(Entity entity) {
        return this.entityLocked != null && entity.m_7306_((Entity)this.entityLocked);
    }

    public void m_20321_(boolean pDownwards) {
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.grounded ? null : super.m_6351_(pStartVec, pEndVec);
    }

    public Packet<?> m_5654_() {
        return super.m_5654_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (pResult.m_82443_() == this.entityLocked && !this.grounded && !this.hitTarget) {
            this.hitTarget = true;
        }
    }

    protected void m_7761_(LivingEntity pLiving) {
        super.m_7761_(pLiving);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
    }

    protected boolean m_142470_(Player p_150196_) {
        return false;
    }

    protected ItemStack m_7941_() {
        return null;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11685_;
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        if (pSound == this.m_7239_()) {
            return;
        }
        super.m_5496_(pSound, pVolume, pPitch);
    }

    public void m_6123_(Player pEntity) {
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        Entity entity = this.f_19853_.m_6815_(pPacket.m_131509_());
        if (entity != null) {
            this.m_5602_(entity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.grounded = pCompound.m_128471_("Grounded");
        if (pCompound.m_128441_("slowDuration")) {
            this.slowDuration = pCompound.m_128451_("slowDuration");
        }
        if (pCompound.m_128441_("frostbiteDuration")) {
            this.frostbiteDuration = pCompound.m_128451_("frostbiteDuration");
        }
        if (pCompound.m_128441_("amplifier")) {
            this.amplifier = pCompound.m_128451_("amplifier");
        }
        if (pCompound.m_128441_("intervalHypothermiaTicks")) {
            this.intervalHypothermiaTicks = pCompound.m_128451_("intervalHypothermiaTicks");
        }
        if (pCompound.m_128441_("frostbiteChance")) {
            this.frostbiteChance = pCompound.m_128457_("frostbiteChance");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Grounded", this.grounded);
        pCompound.m_128405_("slowDuration", this.slowDuration);
        pCompound.m_128405_("frostbiteDuration", this.frostbiteDuration);
        pCompound.m_128405_("amplifier", this.amplifier);
        pCompound.m_128405_("intervalHypothermiaTicks", this.intervalHypothermiaTicks);
        pCompound.m_128350_("frostbiteChance", this.frostbiteChance);
    }

    protected void m_6901_() {
        ++this.life;
        if (this.life >= 20) {
            this.m_146870_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

