/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.client.particles.FireballParticle;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.ClientboundFireballExplosionMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractFireballAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class VaultFireball
extends AbstractArrow {
    private static final EntityDataAccessor<Float> ID_DAMAGE = SynchedEntityData.m_135353_(VaultFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> THROWER_UUID = SynchedEntityData.m_135353_(VaultFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> ID_TYPE = SynchedEntityData.m_135353_(VaultFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(VaultFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ID_BOUNCES = SynchedEntityData.m_135353_(VaultFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static int MAX_AGE = 4;
    private boolean grounded;
    private int life;
    public Vec3 prevDeltaMovement = new Vec3(0.0, 0.0, 0.0);
    private int bounceCount = 0;
    private int duration = 0;
    private boolean leftOwner;
    private boolean hasBeenShot;
    private boolean explodeDelayed;
    private int explodeDelayedTicks;

    public VaultFireball(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public VaultFireball(Level level, LivingEntity thrower) {
        super(ModEntities.FIREBALL, thrower, level);
        this.m_5602_((Entity)thrower);
        this.f_19804_.m_135381_(THROWER_UUID, Optional.of(thrower.m_142081_()));
        this.f_19804_.m_135381_(ID_DAMAGE, (Object)Float.valueOf(this.getDamage()));
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setType(int id) {
        this.f_19804_.m_135381_(ID_TYPE, (Object)id);
    }

    public void setType(String type) {
        this.f_19804_.m_135381_(ID_TYPE, (Object)FireballType.byName(type).ordinal());
    }

    public FireballType getFireballType() {
        return FireballType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE));
    }

    public float getDamage() {
        ServerPlayer serverPlayer;
        AbilityTree abilities;
        Iterator<AbstractFireballAbility> iterator;
        Entity entity = this.m_37282_();
        if (entity instanceof ServerPlayer && (iterator = (abilities = PlayerAbilitiesData.get((serverPlayer = (ServerPlayer)entity).m_183503_()).getAbilities((Player)serverPlayer)).getAll(AbstractFireballAbility.class, Skill::isUnlocked).iterator()).hasNext()) {
            AbstractFireballAbility ability = iterator.next();
            return ability.getAbilityPower(serverPlayer);
        }
        return 0.0f;
    }

    public VaultFireball createBouncingFireball(Level level, LivingEntity thrower, int bounceCount) {
        VaultFireball javelin = new VaultFireball(level, thrower);
        javelin.bounceCount = bounceCount;
        javelin.f_19804_.m_135381_(ID_BOUNCES, (Object)bounceCount);
        return javelin;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_TYPE, (Object)0);
        this.f_19804_.m_135372_(ID_BOUNCES, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(THROWER_UUID, Optional.empty());
    }

    public byte m_36796_() {
        return 0;
    }

    public UUID getThrowerUUID() {
        if (((Optional)this.f_19804_.m_135370_(THROWER_UUID)).isPresent()) {
            return (UUID)((Optional)this.f_19804_.m_135370_(THROWER_UUID)).get();
        }
        return null;
    }

    public Player getThrower() {
        if (((Optional)this.f_19804_.m_135370_(THROWER_UUID)).isPresent()) {
            return this.f_19853_.m_46003_((UUID)((Optional)this.f_19804_.m_135370_(THROWER_UUID)).get());
        }
        return null;
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public static boolean hasLineOfSight(Entity p_147185_, Player thrower) {
        if (p_147185_.f_19853_ != thrower.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(thrower.m_20185_(), thrower.m_20188_(), thrower.m_20189_());
        Vec3 vec31 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20188_(), p_147185_.m_20189_());
        double theta = Math.atan2(p_147185_.m_20189_() - thrower.m_20189_(), p_147185_.m_20185_() - thrower.m_20185_());
        double angle1 = Math.toDegrees(theta - Math.toRadians(90.0));
        double angle2 = thrower.m_146908_();
        double diff = (angle2 - angle1 + 180.0) % 360.0 - 180.0;
        diff = Math.abs(diff < -180.0 ? diff + 360.0 : diff);
        if (diff > 75.0) {
            return false;
        }
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return thrower.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)thrower)).m_6662_() == HitResult.Type.MISS;
    }

    private boolean shouldFall() {
        return this.f_36703_ && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.f_36703_ = false;
        Vec3 vec3 = this.m_20184_();
        this.life = 0;
    }

    private boolean checkLeftOwner() {
        Entity entity = this.m_37282_();
        if (entity != null) {
            for (Entity entity1 : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_20068_() {
        return super.m_20068_();
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (this.f_36704_ > 4) {
            this.grounded = true;
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.explodeDelayed) {
                --this.explodeDelayedTicks;
                if (this.explodeDelayedTicks <= 0) {
                    this.explode(this.m_20182_());
                }
            }
            if (this.getFireballType() == FireballType.BOUNCING && this.duration != 0 && this.f_19797_ >= this.duration * 20) {
                this.explode(this.m_20182_());
            }
        }
        if (this.f_19853_.m_5776_() && !this.grounded && (this.f_19797_ > 4 || (Integer)this.f_19804_.m_135370_(ID_BOUNCES) > 0)) {
            this.particleTrail();
        }
        this.prevDeltaMovement = this.m_20184_();
        this.m_6075_();
        if (!this.hasBeenShot) {
            this.m_146855_(GameEvent.f_157778_, this.m_37282_(), this.m_142538_());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_142538_())).m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.shouldFall()) {
                this.startFalling();
            } else if (!this.f_19853_.f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            Vec3 vec33;
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_146910_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(VaultFireball.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(VaultFireball.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            float f1 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f2 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                boolean bouncing = this.getFireballType() == FireballType.BOUNCING;
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.025f * (double)(bouncing ? 4 : 1), vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos, float radius) {
        AABB aabb = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        return world.m_45976_(LivingEntity.class, aabb);
    }

    protected void m_6532_(@NotNull HitResult result) {
        Entity entity;
        if (!this.f_19853_.m_5776_() && (entity = this.m_37282_()) instanceof LivingEntity) {
            Entity player;
            LivingEntity living;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getFireballType() == FireballType.BOUNCING && this.m_37282_() != null) {
                Vec3 motion;
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    motion = this.prevDeltaMovement;
                    Direction face = ((BlockHitResult)result).m_82434_();
                    Vec3 normal = new Vec3((double)face.m_122436_().m_123341_(), (double)face.m_122436_().m_123342_(), (double)face.m_122436_().m_123343_());
                    double dot = motion.m_82526_(normal) * 1.5;
                    Vec3 reflect = motion.m_82546_(normal.m_82559_(new Vec3(dot, dot, dot))).m_82520_(0.0, (double)0.1f, 0.0).m_82559_(new Vec3((double)0.9f, (double)0.9f, (double)0.9f));
                    VaultFireball fireball = this.createBouncingFireball(this.f_19853_, livingEntity, this.bounceCount + 1);
                    fireball.m_6034_(result.m_82450_().m_7096_() + reflect.m_82541_().f_82479_ / 50.0, result.m_82450_().m_7098_() + reflect.m_82541_().f_82480_ / 50.0, result.m_82450_().m_7094_() + reflect.m_82541_().f_82481_ / 50.0);
                    fireball.m_20256_(reflect);
                    double d0 = reflect.m_165924_();
                    fireball.f_19860_ = (float)(Mth.m_14136_((double)reflect.f_82480_, (double)d0) * 57.2957763671875);
                    fireball.f_19859_ = (float)(Mth.m_14136_((double)reflect.f_82479_, (double)reflect.f_82481_) * 57.2957763671875);
                    fireball.m_37283_();
                    fireball.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                    fireball.setType(this.getFireballType().ordinal());
                    fireball.setDuration(this.getDuration());
                    fireball.f_19797_ = this.f_19797_;
                    this.f_19853_.m_7967_((Entity)fireball);
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                } else if (result.m_6662_() == HitResult.Type.ENTITY && (motion = ((EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
                    Entity dot;
                    living = (LivingEntity)motion;
                    Entity entity2 = ((EntityHitResult)result).m_82443_();
                    if (this.m_37282_() != null && (dot = this.m_37282_()) instanceof ServerPlayer) {
                        LivingEntity livingHit;
                        player = (ServerPlayer)dot;
                        if (entity2 instanceof LivingEntity && !((livingHit = (LivingEntity)entity2) instanceof Player)) {
                            float attackDamage = this.getDamage();
                            DamageSource damageSource = DamageSource.m_19344_((Player)player);
                            ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> livingHit.m_6469_(damageSource, attackDamage * 0.25f)));
                            player.f_19853_.m_6263_(null, this.m_20318_((float)0.0f).f_82479_, this.m_20318_((float)0.0f).f_82480_, this.m_20318_((float)0.0f).f_82481_, SoundEvents.f_11874_, SoundSource.PLAYERS, 0.2f, 1.0f);
                        }
                    }
                }
            }
            if (this.getFireballType() == FireballType.FIRESHOT) {
                Entity player2;
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 0.5, 1));
                    if (this.m_37282_() != null && (player = this.m_37282_()) instanceof ServerPlayer) {
                        player2 = (ServerPlayer)player;
                        player2.f_19853_.m_6263_(null, this.m_20318_((float)0.0f).f_82479_, this.m_20318_((float)0.0f).f_82480_, this.m_20318_((float)0.0f).f_82481_, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.25f);
                    }
                } else if (result.m_6662_() == HitResult.Type.ENTITY && (player2 = ((EntityHitResult)result).m_82443_()) instanceof LivingEntity && !((living = (LivingEntity)player2) instanceof Player)) {
                    if (this.m_37282_() != null && (player = this.m_37282_()) instanceof ServerPlayer) {
                        player2 = (ServerPlayer)player;
                        float attackDamage = this.getDamage();
                        DamageSource damageSource = DamageSource.m_19344_((Player)player2);
                        ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_FIRESHOT_ATTACKING.runIfNotSet(() -> living.m_6469_(damageSource, attackDamage)));
                        player2.f_19853_.m_6263_(null, this.m_20318_((float)0.0f).f_82479_, this.m_20318_((float)0.0f).f_82480_, this.m_20318_((float)0.0f).f_82481_, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.25f);
                    }
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 0.5, 1));
                }
            }
        }
        if (!this.explodeDelayed && this.getFireballType() == FireballType.BASE) {
            this.explodeDelayed();
        }
        super.m_6532_(result);
    }

    public void explodeDelayed() {
        this.explodeDelayed = true;
        this.explodeDelayedTicks = 2;
    }

    public void explode(Vec3 pos) {
        Entity entity;
        if (this.m_37282_() != null && (entity = this.m_37282_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float radius = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, 3.0f);
            List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos, radius);
            targetEntities.removeIf(livingEntity -> livingEntity.m_20238_(pos) > (double)(radius * radius));
            float attackDamage = this.getDamage();
            DamageSource damageSource = DamageSource.m_19344_((Player)player);
            for (LivingEntity entity2 : targetEntities) {
                ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                    if (!(entity2 instanceof Player)) {
                        if (entity2.m_6469_(damageSource, attackDamage)) {
                            double dz;
                            double dx = pos.f_82479_ - entity2.m_20185_();
                            if (dx * dx + (dz = pos.f_82481_ - entity2.m_20189_()) * dz < 1.0E-4) {
                                dx = (Math.random() - Math.random()) * 0.01;
                                dz = (Math.random() - Math.random()) * 0.01;
                            }
                            entity2.m_147240_((double)0.6f, dx, dz);
                        }
                    } else if (entity.f_20916_ == 0 && !((Player)entity2).m_7500_()) {
                        entity2.m_21153_(entity2.m_21223_() - entity2.m_21233_() * 0.2f);
                        if (entity2.m_21224_()) {
                            entity2.m_6667_(entity2.m_21225_() != null ? entity2.m_21225_() : DamageSource.f_19318_);
                        }
                    }
                }));
            }
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, radius / 4.0f - 0.5f, 20));
            ServerScheduler.INSTANCE.schedule(3, () -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, radius / 2.0f - 0.5f, 40)));
            ServerScheduler.INSTANCE.schedule(6, () -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, radius / 2.0f + radius / 4.0f - 0.5f, 60)));
            ServerScheduler.INSTANCE.schedule(9, () -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, radius / 2.0f + radius / 4.0f + radius / 8.0f, 80)));
            ServerScheduler.INSTANCE.schedule(12, () -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFireballExplosionMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, radius, 100)));
            player.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void particleTrail() {
        Particle particle;
        Vec3 direction;
        Vec3 offset;
        int i;
        ParticleEngine pm = Minecraft.m_91087_().f_91061_;
        for (i = 0; i < 2; ++i) {
            offset = new Vec3(this.f_19796_.nextDouble() / 5.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), 0.0, this.f_19796_.nextDouble() / 5.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1));
            direction = this.m_20184_().m_82541_().m_82490_((double)0.05f);
            particle = pm.m_107370_((ParticleOptions)ParticleTypes.f_123744_, this.m_20182_().f_82479_ + offset.f_82479_ + direction.f_82479_ * (double)this.f_19796_.nextFloat() * (double)0.2f, this.m_20182_().f_82480_ + direction.f_82480_ * (double)this.f_19796_.nextFloat() * (double)0.2f, this.m_20182_().f_82481_ + offset.f_82481_ + direction.f_82481_ * (double)this.f_19796_.nextFloat() * (double)0.2f, direction.f_82479_, direction.f_82480_, direction.f_82481_);
            if (particle == null) continue;
            particle.m_107257_((int)(10.0 + (double)this.f_19796_.nextFloat() * 3.0));
        }
        for (i = 0; i < 1; ++i) {
            offset = new Vec3(this.f_19796_.nextDouble() / 8.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), this.f_19796_.nextDouble() / 8.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), this.f_19796_.nextDouble() / 8.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1));
            direction = this.m_20184_().m_82541_().m_82490_((double)0.05f);
            particle = pm.m_107370_((ParticleOptions)ModParticles.FIREBALL_CLOUD.get(), this.m_20182_().f_82479_ + offset.f_82479_ + direction.f_82479_ * (double)this.f_19796_.nextFloat() * (double)0.2f, this.m_20182_().f_82480_ + offset.f_82480_ + direction.f_82480_ * (double)this.f_19796_.nextFloat() * (double)0.2f, this.m_20182_().f_82481_ + offset.f_82481_ + direction.f_82481_ * (double)this.f_19796_.nextFloat() * (double)0.2f, direction.f_82479_, direction.f_82480_, direction.f_82481_);
            if (!(particle instanceof FireballParticle)) continue;
            FireballParticle fireballParticle = (FireballParticle)particle;
            float colorOffset = this.f_19796_.nextFloat() * 0.2f;
            if (this.f_19796_.nextBoolean()) {
                fireballParticle.setStartColor(0.48359376f + colorOffset, 0.06953125f + colorOffset, 0.0703125f);
            } else {
                fireballParticle.setStartColor(0.75f + colorOffset, 0.35f + colorOffset, 0.0f);
            }
            float col = Mth.m_14068_((Random)this.f_19796_, (float)0.01f, (float)0.15f);
            fireballParticle.setEndColor(col, col, col);
            if (this.getFireballType() != FireballType.FIRESHOT) continue;
            fireballParticle.m_6569_(0.5f);
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return super.m_5603_(entity) && !(entity instanceof Player) && !(entity instanceof EternalEntity);
    }

    public void m_20321_(boolean pDownwards) {
        super.m_20321_(pDownwards);
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.grounded ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
    }

    protected void m_7761_(LivingEntity pLiving) {
        super.m_7761_(pLiving);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
    }

    protected boolean m_142470_(Player p_150196_) {
        return false;
    }

    protected ItemStack m_7941_() {
        return null;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11685_;
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        if (pSound == this.m_7239_()) {
            return;
        }
        super.m_5496_(pSound, pVolume, pPitch);
    }

    public void m_6123_(Player pEntity) {
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        Entity entity = this.f_19853_.m_6815_(pPacket.m_131509_());
        if (entity != null) {
            this.m_5602_(entity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.grounded = pCompound.m_128471_("Grounded");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Grounded", this.grounded);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
        this.life = age;
    }

    public void m_6901_() {
        if (this.grounded) {
            this.setAge(this.life + 1);
            if (this.life >= MAX_AGE) {
                this.explode(this.m_20182_());
            }
        } else {
            this.setAge(0);
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public static enum FireballType {
        BASE("base"),
        BOUNCING("bouncing"),
        FIRESHOT("fireshot");

        private final String name;

        private FireballType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static FireballType byId(int pId) {
            FireballType[] javelinType = FireballType.values();
            if (pId < 0 || pId >= javelinType.length) {
                pId = 0;
            }
            return javelinType[pId];
        }

        public static FireballType byName(String pName) {
            FireballType[] javelinType = FireballType.values();
            for (int i = 0; i < javelinType.length; ++i) {
                if (!javelinType[i].getName().equals(pName)) continue;
                return javelinType[i];
            }
            return javelinType[0];
        }
    }
}

