/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.guardian.CrossbowHelper;
import iskallia.vault.entity.entity.guardian.FixedArrowEntity;
import iskallia.vault.entity.entity.guardian.GuardianStats;
import iskallia.vault.entity.entity.guardian.GuardianType;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VaultGuardianEntity
extends Piglin {
    private GuardianType type;
    private GuardianStats stats = new GuardianStats.Empty();

    public VaultGuardianEntity(EntityType<? extends Piglin> entityType, GuardianType type, Level world) {
        super(entityType, world);
        this.type = type;
        this.m_34670_(true);
        this.m_21553_(false);
        this.m_21530_();
    }

    public void setType(GuardianType type) {
        this.type = type;
    }

    public boolean m_6779_(LivingEntity target) {
        return true;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return InteractionResult.PASS;
    }

    public void m_32336_(LivingEntity entity, float distance) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)entity, item -> item instanceof CrossbowItem);
        ItemStack itemstack = entity.m_21120_(interactionhand).m_41777_();
        ListTag list = new ListTag();
        list.add((Object)new ItemStack((ItemLike)Items.f_42412_).serializeNBT());
        itemstack.m_41784_().m_128365_("ChargedProjectiles", (Tag)list);
        if (entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            CrossbowHelper.performShooting(entity.f_19853_, entity, interactionhand, itemstack, 2.2f, 0.0f);
        }
        this.m_5847_();
    }

    public void m_32322_(LivingEntity p_32323_, LivingEntity p_32324_, Projectile p_32325_, float p_32326_, float p_32327_) {
        ((FixedArrowEntity)p_32325_).m_36781_(this.m_21051_(Attributes.f_22281_).m_22135_());
        super.m_32322_(p_32323_, p_32324_, p_32325_, p_32326_, p_32327_);
    }

    protected void m_7625_(DamageSource source, boolean attackedRecently) {
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            ServerVaults.get(this.f_19853_).ifPresent(vault -> {
                if (this.type != null) {
                    this.stats = ModConfigs.VAULT_GUARDIAN.get(vault.get(Vault.LEVEL).get(), this.type);
                }
            });
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.stats.onTick(this);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!(source.m_7639_() instanceof Player) && !(source.m_7639_() instanceof EternalEntity)) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.stats.onHurt(this, source, amount);
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_19360_() || source == DamageSource.f_19315_;
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag;
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22115_();
        float f1 = (float)this.m_21051_(Attributes.f_22282_).m_22115_();
        int i = EnchantmentHelper.m_44914_((LivingEntity)this);
        if (i > 0) {
            pEntity.m_20254_(i * 4);
        }
        if (flag = pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), f)) {
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                ((LivingEntity)pEntity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        return flag;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.type = GuardianType.values()[nbt.m_128451_("Type")];
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Type", this.type.ordinal());
    }
}

