/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfig;

public class VaultGummySoldier
extends Monster {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(VaultGummySoldier.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SPECIAL_TYPE_ID = SynchedEntityData.m_135353_(VaultGummySoldier.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_DROWNED_CONVERSION_ID = SynchedEntityData.m_135353_(VaultGummySoldier.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34284_ -> p_34284_ == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;

    public VaultGummySoldier(EntityType<? extends VaultGummySoldier> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(2, (Goal)new GummyAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_SPECIAL_TYPE_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_DROWNED_CONVERSION_ID, (Object)false);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean pEnabled) {
        if (this.supportsBreakDoorGoal() && GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != pEnabled) {
                this.canBreakDoors = pEnabled;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(pEnabled);
                if (pEnabled) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.6f : 1.0f;
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    protected int m_6552_(Player pPlayer) {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((double)this.f_21364_ * 2.5);
        }
        return super.m_6552_(pPlayer);
    }

    public void m_6863_(boolean pChildZombie) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)pChildZombie);
        if (!this.f_19853_.f_46443_) {
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_BABY);
            if (pChildZombie) {
                attributeinstance.m_22118_(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            boolean flag;
            boolean bl = flag = this.isSunSensitive() && this.m_21527_();
            if (flag) {
                ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41763_()) {
                        itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.nextInt(2));
                        if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                            this.m_21166_(EquipmentSlot.HEAD);
                            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.m_20254_(8);
                }
            }
        }
        super.m_8107_();
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!super.m_6469_(pSource, pAmount)) {
            return false;
        }
        return this.f_19853_ instanceof ServerLevel;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.nextFloat() < f * 0.3f) {
                pEntity.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    public SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12384_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    protected SoundEvent getStepSound() {
        return this.m_6162_() ? SoundEvents.f_12468_ : SoundEvents.f_12386_;
    }

    protected SoundEvent getAttackSound() {
        return SoundEvents.f_12384_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.4f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_6851_(DifficultyInstance pDifficulty) {
        super.m_6851_(pDifficulty);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsBaby", this.m_6162_());
        pCompound.m_128379_("CanBreakDoors", this.canBreakDoors());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_6863_(pCompound.m_128471_("IsBaby"));
        this.setCanBreakDoors(pCompound.m_128471_("CanBreakDoors"));
    }

    public void m_5837_(ServerLevel pLevel, LivingEntity pKilledEntity) {
        super.m_5837_(pLevel, pKilledEntity);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public boolean m_7252_(ItemStack pStack) {
        return (!pStack.m_150930_(Items.f_42521_) || !this.m_6162_() || !this.m_20159_()) && super.m_7252_(pStack);
    }

    public boolean m_7243_(ItemStack p_182400_) {
        return !p_182400_.m_150930_(Items.f_151056_) && super.m_7243_(p_182400_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        float f = pDifficulty.m_19057_();
        this.m_21553_(this.f_19796_.nextFloat() < 0.55f * f);
        if (pSpawnData == null) {
            pSpawnData = new GummyGroupData(VaultGummySoldier.getSpawnAsBabyOdds(pLevel.m_5822_()), true);
        }
        if (pSpawnData instanceof GummyGroupData) {
            GummyGroupData groupData = (GummyGroupData)pSpawnData;
            if (groupData.isBaby) {
                this.m_6863_(true);
                if (groupData.canSpawnJockey) {
                    if ((double)pLevel.m_5822_().nextFloat() < 0.05) {
                        List list = pLevel.m_6443_(Chicken.class, this.m_142469_().m_82377_(5.0, 3.0, 5.0), EntitySelector.f_20404_);
                        if (!list.isEmpty()) {
                            Chicken chicken = (Chicken)list.get(0);
                            chicken.m_28273_(true);
                            this.m_20329_((Entity)chicken);
                        }
                    } else if ((double)pLevel.m_5822_().nextFloat() < 0.05) {
                        Chicken chicken1 = (Chicken)EntityType.f_20555_.m_20615_(this.f_19853_);
                        chicken1.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                        chicken1.m_6518_(pLevel, pDifficulty, MobSpawnType.JOCKEY, (SpawnGroupData)null, (CompoundTag)null);
                        chicken1.m_28273_(true);
                        this.m_20329_((Entity)chicken1);
                        pLevel.m_7967_((Entity)chicken1);
                    }
                }
            }
            this.setCanBreakDoors(this.supportsBreakDoorGoal() && this.f_19796_.nextFloat() < f * 0.1f);
            this.m_6851_(pDifficulty);
            this.m_6850_(pDifficulty);
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.f_19796_.nextFloat() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.nextFloat() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        return pSpawnData;
    }

    public static boolean getSpawnAsBabyOdds(Random p_34303_) {
        return (double)p_34303_.nextFloat() < (Double)ForgeConfig.SERVER.zombieBabyChance.get();
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public class GummyAttackGoal
    extends MeleeAttackGoal {
        private final VaultGummySoldier vaultGummySoldier;
        private int raiseArmTicks;

        public GummyAttackGoal(VaultGummySoldier vaultGummySoldier, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)vaultGummySoldier, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.vaultGummySoldier = vaultGummySoldier;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                this.f_25540_.m_7327_((Entity)pEnemy);
                VaultGummySoldier.this.m_5496_(VaultGummySoldier.this.getAttackSound(), 1.0f, 1.0f);
            }
        }

        public void m_8056_() {
            super.m_8056_();
            this.raiseArmTicks = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.vaultGummySoldier.m_21561_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.raiseArmTicks;
            if (this.raiseArmTicks >= 5 && this.m_25565_() < this.m_25566_() / 2) {
                this.vaultGummySoldier.m_21561_(true);
            } else {
                this.vaultGummySoldier.m_21561_(false);
            }
        }
    }

    public static class GummyGroupData
    implements SpawnGroupData {
        public final boolean isBaby;
        public final boolean canSpawnJockey;

        public GummyGroupData(boolean p_34357_, boolean p_34358_) {
            this.isBaby = p_34357_;
            this.canSpawnJockey = p_34358_;
        }
    }
}

