/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.VaultBlizzardShard;
import iskallia.vault.entity.entity.VaultStormArrow;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.calc.AbilityPowerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VaultStormEntity
extends Entity {
    private int duration;
    private float radius;
    private float percentAbilityPowerDealt;
    private int intervalTicks;
    private int intervalTicksMax;
    private int frostbiteDuration;
    private int slowDuration;
    private int amplifier;
    private int intervalHypothermiaTicks;
    private float frostbiteChance;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private static final EntityDataAccessor<Integer> ID_TYPE = SynchedEntityData.m_135353_(VaultStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(VaultStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final Predicate<Entity> ENTITY_PREDICATE = entity -> {
        LivingEntity livingEntity;
        return !(entity instanceof Player) && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_();
    };

    public VaultStormEntity(EntityType<? extends VaultStormEntity> type, Level world) {
        super(type, world);
        this.m_20331_(true);
        this.radius = 5.0f;
        this.intervalTicks = 0;
        this.intervalTicksMax = 10;
    }

    public VaultStormEntity(Level world, double x, double y, double z, float radius, int duration, Entity owner, float percentAbilityPowerDealt, int intervalTicks) {
        this(ModEntities.STORM, world);
        this.m_6034_(x, y, z);
        this.m_146922_((float)(this.f_19796_.nextDouble() * 360.0));
        this.intervalTicks = 0;
        this.intervalTicksMax = intervalTicks;
        this.duration = duration;
        this.radius = radius;
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
        this.setOwner(owner);
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_146910_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.f_19853_ instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity pEntity) {
        if (pEntity != null) {
            this.ownerUUID = pEntity.m_142081_();
            this.cachedOwner = pEntity;
        }
    }

    public void setSlowDuration(int slowDuration) {
        this.slowDuration = slowDuration;
    }

    public void setFrostbiteDuration(int frostbiteDuration) {
        this.frostbiteDuration = frostbiteDuration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setFrostbiteChance(float frostbiteChance) {
        this.frostbiteChance = frostbiteChance;
    }

    public void setIntervalHypothermiaTicks(int intervalHypothermiaTicks) {
        this.intervalHypothermiaTicks = intervalHypothermiaTicks;
    }

    public int getSlowDuration() {
        return this.slowDuration;
    }

    public int getFrostbiteDuration() {
        return this.frostbiteDuration;
    }

    private int getAmplifier() {
        return this.amplifier;
    }

    private int getIntervalHypothermiaTicks() {
        return this.intervalHypothermiaTicks;
    }

    private float getFrostbiteChance() {
        return this.frostbiteChance;
    }

    public void setIdType(int type) {
        this.f_19804_.m_135381_(ID_TYPE, (Object)type);
    }

    public int getDuration() {
        return this.duration;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6097_() {
        return false;
    }

    public SoundSource m_5720_() {
        return SoundSource.AMBIENT;
    }

    public static Vec3 generatePointInCircle(Vec3 center, double radius, double time, Random random, boolean below) {
        double angle = Math.PI * 2 * random.nextDouble();
        double distance = Math.sqrt(random.nextDouble());
        double cloudRadius = radius + Math.sin(3.0 * angle + time) * radius * 0.13 + Math.sin(4.0 * (angle + Math.sin(time)) + time * 2.0) * radius * 0.13 + Math.sin(5.0 * (angle + Math.sin(time)) + time * 3.0) * radius * 0.13;
        double height = (1.0 - distance * distance * distance) / radius * cloudRadius * 0.75;
        if (!below) {
            if (random.nextBoolean()) {
                height *= -1.0;
            }
        } else {
            height *= -1.0;
        }
        double x = center.m_7096_() + Math.cos(angle) * cloudRadius * distance;
        double y = center.m_7098_() + height;
        double z = center.m_7094_() + Math.sin(angle) * cloudRadius * distance;
        return new Vec3(x, y, z);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            Vec3 vec3;
            int i = 0;
            while ((float)i < 6.0f * ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue()) {
                vec3 = VaultStormEntity.generatePointInCircle(this.m_20182_(), ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue() + 0.5f, (float)this.f_19797_ / 50.0f, this.f_19796_, false);
                ParticleEngine pm = Minecraft.m_91087_().f_91061_;
                Particle particle = pm.m_107370_((ParticleOptions)ModParticles.STORM_CLOUD.get(), vec3.m_7096_(), vec3.m_7098_() + this.f_19796_.nextDouble() * (double)0.4f, vec3.m_7094_(), 0.0, 0.0, 0.0);
                if (VaultStormArrow.StormType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE)) == VaultStormArrow.StormType.BLIZZARD && particle != null) {
                    float f = this.f_19796_.nextFloat() * 0.1f;
                    particle.m_107253_(0.6f + f, 0.7f + f, 0.9f + f);
                }
                ++i;
            }
            i = 0;
            while ((float)i < ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue() / 4.0f) {
                vec3 = VaultStormEntity.generatePointInCircle(this.m_20182_(), ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue() + 0.5f, (float)this.f_19797_ / 50.0f, this.f_19796_, true);
                if (VaultStormArrow.StormType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE)) == VaultStormArrow.StormType.BASE) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, vec3.m_7096_(), vec3.m_7098_() + this.f_19796_.nextDouble() * (double)0.4f, vec3.m_7094_(), 0.0, 0.0, 0.0);
                } else if (VaultStormArrow.StormType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE)) == VaultStormArrow.StormType.BLIZZARD) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_(), vec3.m_7098_() + this.f_19796_.nextDouble() * (double)0.4f, vec3.m_7094_(), 0.0, 0.0, 0.0);
                }
                ++i;
            }
        } else {
            if (this.intervalTicks > 0) {
                --this.intervalTicks;
            } else {
                Entity vec3 = this.getOwner();
                if (vec3 instanceof Player) {
                    Player player = (Player)vec3;
                    if (VaultStormArrow.StormType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE)) == VaultStormArrow.StormType.BASE) {
                        result = new ArrayList<LivingEntity>();
                        VaultStormEntity.getEntitiesInRange((LevelAccessor)player.f_19853_, this.m_20182_(), this.radius, ENTITY_PREDICATE, result, 14.0f);
                        result.removeIf(entity -> entity instanceof EternalEntity);
                        if (!result.isEmpty()) {
                            LivingEntity livingEntity = result.get(player.f_19853_.f_46441_.nextInt(result.size()));
                            SmiteBolt smiteBolt = (SmiteBolt)ModEntities.THUNDERSTORM_BOLT.m_20615_(player.f_19853_);
                            if (smiteBolt != null) {
                                smiteBolt.setColor(0xFFFEFF);
                                smiteBolt.m_20219_(livingEntity.m_20182_());
                                smiteBolt.setSize((float)(this.m_20182_().f_82480_ - livingEntity.m_20182_().f_82480_));
                                player.f_19853_.m_7967_((Entity)smiteBolt);
                            }
                            ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_SMITE_ATTACKING.runIfNotSet(() -> {
                                double damage = AbilityPowerHelper.getAbilityPower(player) * this.percentAbilityPowerDealt;
                                Vec3 delta = livingEntity.m_20184_();
                                livingEntity.m_6469_(DamageSource.m_19344_((Player)player), (float)damage);
                                livingEntity.m_20256_(delta);
                            }));
                            player.f_19853_.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), ModSounds.SMITE_BOLT, SoundSource.PLAYERS, 1.0f, 1.0f + Mth.m_144924_((Random)livingEntity.m_21187_(), (float)-0.2f, (float)0.2f));
                        }
                    } else if (VaultStormArrow.StormType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE)) == VaultStormArrow.StormType.BLIZZARD) {
                        result = new ArrayList();
                        VaultStormEntity.getEntitiesInRange((LevelAccessor)player.f_19853_, this.m_20182_(), this.radius, ENTITY_PREDICATE, result, 14.0f);
                        result.removeIf(entity -> entity instanceof EternalEntity);
                        if (!result.isEmpty()) {
                            LivingEntity livingEntity = result.get(player.f_19853_.f_46441_.nextInt(result.size()));
                            VaultBlizzardShard shard = (VaultBlizzardShard)ModEntities.BLIZZARD_SHARD.m_20615_(player.f_19853_);
                            if (shard != null) {
                                Vec3 pos = livingEntity.m_20182_();
                                pos = new Vec3(pos.f_82479_, this.m_20186_(), pos.f_82481_);
                                shard.m_20219_(pos);
                                shard.m_5602_(this.getOwner());
                                shard.setEntityLocked(livingEntity);
                                shard.setAmplifier(this.getAmplifier());
                                shard.setSlowDuration(this.getSlowDuration());
                                shard.setFrostbiteDuration(this.getFrostbiteDuration());
                                shard.setFrostbiteChance(this.getFrostbiteChance());
                                shard.setIntervalHypothermiaTicks(this.getIntervalHypothermiaTicks());
                                player.f_19853_.m_7967_((Entity)shard);
                            }
                        }
                    }
                    this.intervalTicks = this.intervalTicksMax;
                }
            }
            if (--this.duration < 0) {
                this.m_146870_();
            }
        }
    }

    public static void getEntitiesInRange(LevelAccessor levelAccessor, Vec3 center, float range, Predicate<Entity> filter, List<LivingEntity> result, float height) {
        VaultStormEntity.getEntitiesInRange(levelAccessor, new AABB(center.f_82479_ - (double)(range + 4.0f), center.f_82480_ - (double)(height + 4.0f), center.f_82481_ - (double)(range + 4.0f), center.f_82479_ + (double)(range + 4.0f), center.f_82480_ + (double)(height + 4.0f), center.f_82481_ + (double)(range + 4.0f)), center, range, filter, result, height);
    }

    public static void getEntitiesInRange(LevelAccessor levelAccessor, AABB area, Vec3 center, float range, Predicate<Entity> filter, List<LivingEntity> result, float height) {
        if (levelAccessor == null) {
            return;
        }
        List entityList = levelAccessor.m_6249_((Entity)null, area, filter);
        for (Entity entity : entityList) {
            if (!VaultStormEntity.isAABBIntersectingOrInsideCylinder(entity, center.f_82479_, center.f_82480_, center.f_82481_, range, height)) continue;
            result.add((LivingEntity)entity);
        }
    }

    public static double getDistanceInXZ(Vec3 point1, Vec3 point2) {
        double deltaX = point2.m_7096_() - point1.m_7096_();
        double deltaZ = point2.m_7094_() - point1.m_7094_();
        return Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
    }

    public static boolean isAABBIntersectingOrInsideCylinder(Entity entity, double xCylinderCenter, double yCylinderCenter, double zCylinderCenter, double cylinderRadius, double cylinderHeight) {
        if (entity.m_20182_().f_82480_ + (double)entity.m_20206_() > yCylinderCenter) {
            return false;
        }
        if (entity.m_20182_().f_82480_ < yCylinderCenter - cylinderHeight) {
            return false;
        }
        return !(VaultStormEntity.getDistanceInXZ(entity.m_20182_(), new Vec3(xCylinderCenter, yCylinderCenter, zCylinderCenter)) > cylinderRadius);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(5.0f));
        this.m_20088_().m_135372_(ID_TYPE, (Object)0);
    }

    protected void m_5841_() {
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Duration", this.duration);
        pCompound.m_128350_("Radius", this.radius);
        pCompound.m_128350_("PercentAbilityPowerDealt", this.percentAbilityPowerDealt);
        pCompound.m_128405_("IntervalTicks", this.intervalTicks);
        pCompound.m_128405_("IntervalTicksMax", this.intervalTicksMax);
        pCompound.m_128405_("Type", ((Integer)this.f_19804_.m_135370_(ID_TYPE)).intValue());
        pCompound.m_128405_("slowDuration", this.slowDuration);
        pCompound.m_128405_("frostbiteDuration", this.frostbiteDuration);
        pCompound.m_128405_("amplifier", this.amplifier);
        pCompound.m_128405_("intervalHypothermiaTicks", this.intervalHypothermiaTicks);
        pCompound.m_128350_("frostbiteChance", this.frostbiteChance);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        this.duration = pCompound.m_128451_("Duration");
        this.radius = pCompound.m_128457_("Radius");
        this.percentAbilityPowerDealt = pCompound.m_128457_("PercentAbilityPowerDealt");
        this.intervalTicks = pCompound.m_128451_("IntervalTicks");
        this.intervalTicksMax = pCompound.m_128451_("IntervalTicksMax");
        this.f_19804_.m_135381_(ID_TYPE, (Object)pCompound.m_128451_("Type"));
        if (pCompound.m_128441_("slowDuration")) {
            this.slowDuration = pCompound.m_128451_("slowDuration");
        }
        if (pCompound.m_128441_("frostbiteDuration")) {
            this.frostbiteDuration = pCompound.m_128451_("frostbiteDuration");
        }
        if (pCompound.m_128441_("amplifier")) {
            this.amplifier = pCompound.m_128451_("amplifier");
        }
        if (pCompound.m_128441_("intervalHypothermiaTicks")) {
            this.intervalHypothermiaTicks = pCompound.m_128451_("intervalHypothermiaTicks");
        }
        if (pCompound.m_128441_("frostbiteChance")) {
            this.frostbiteChance = pCompound.m_128457_("frostbiteChance");
        }
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public Packet<?> m_5654_() {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_142049_());
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        Entity entity = this.f_19853_.m_6815_(pPacket.m_131509_());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public static class SmiteBolt
    extends Entity {
        private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SmiteBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(SmiteBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private final boolean flashSky;
        private int life;
        public long seed;
        private int flashes;

        public SmiteBolt(EntityType<? extends SmiteBolt> entityType, Level level, boolean flashSky, int color) {
            super(entityType, level);
            this.flashSky = flashSky;
            this.f_19811_ = true;
            this.life = 2;
            this.seed = this.f_19796_.nextLong();
            this.flashes = this.f_19796_.nextInt(3) + 1;
            this.setSize(-1.0f);
            this.setColor(color);
        }

        public void setSize(float size) {
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
        }

        @Nonnull
        public SoundSource m_5720_() {
            return SoundSource.PLAYERS;
        }

        protected void m_8097_() {
            this.f_19804_.m_135372_(COLOR, (Object)0);
            this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
        }

        @Nonnull
        public Packet<?> m_5654_() {
            return new ClientboundAddEntityPacket((Entity)this);
        }

        public void setColor(int color) {
            this.f_19804_.m_135381_(COLOR, (Object)color);
        }

        public void m_8119_() {
            super.m_8119_();
            --this.life;
            if (this.life < 0) {
                if (this.flashes == 0) {
                    this.m_146870_();
                } else if (this.life < -this.f_19796_.nextInt(10)) {
                    --this.flashes;
                    this.life = 1;
                    this.seed = this.f_19796_.nextLong();
                }
            }
            if (this.life >= 0 && this.flashSky && !(this.f_19853_ instanceof ServerLevel)) {
                this.f_19853_.m_6580_(2);
            }
        }

        public boolean m_6783_(double distance) {
            double dSqr = 64.0 * SmiteBolt.m_20150_();
            return distance < dSqr * dSqr;
        }

        protected void m_7378_(@Nonnull CompoundTag compound) {
        }

        protected void m_7380_(@Nonnull CompoundTag compound) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SmiteBoltRenderer
    extends EntityRenderer<SmiteBolt> {
        public SmiteBoltRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        @Nonnull
        public ResourceLocation getTextureLocation(@Nonnull SmiteBolt entity) {
            return TextureAtlas.f_118259_;
        }

        @ParametersAreNonnullByDefault
        public void render(SmiteBolt entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int packedLight) {
            float[] afloat = new float[8];
            float[] afloat1 = new float[8];
            float f = 0.0f;
            float f1 = 0.0f;
            float size = ((Float)entity.m_20088_().m_135370_(SmiteBolt.SIZE)).floatValue();
            if (size == -1.0f) {
                return;
            }
            Random random = new Random(entity.seed);
            for (int i = 7; i >= 0; --i) {
                afloat[i] = f;
                afloat1[i] = f1;
                f += (float)(random.nextInt(11) - 5);
                f1 += (float)(random.nextInt(11) - 5);
            }
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110502_());
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.1f * (size / 1.5f) / 9.0f, 0.1f * size / 13.0f, 0.1f * (size / 1.5f) / 9.0f);
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            for (int j = 0; j < 4; ++j) {
                Random random1 = new Random(entity.seed);
                for (int k = 0; k < 3; ++k) {
                    int l = 7;
                    int i1 = 0;
                    if (k > 0) {
                        l = 7 - k;
                    }
                    if (k > 0) {
                        i1 = l - 2;
                    }
                    float f2 = afloat[l] - f;
                    float f3 = afloat1[l] - f1;
                    for (int j1 = l; j1 >= i1; --j1) {
                        float f4 = f2;
                        float f5 = f3;
                        if (k == 0) {
                            f2 += (float)(random1.nextInt(11) - 5);
                            f3 += (float)(random1.nextInt(11) - 5);
                        } else {
                            f2 += (float)(random1.nextInt(31) - 15);
                            f3 += (float)(random1.nextInt(31) - 15);
                        }
                        float f10 = 0.1f + (float)j * 0.2f;
                        if (k == 0) {
                            f10 *= (float)j1 * 0.1f + 1.0f;
                        }
                        float f11 = 0.1f + (float)j * 0.2f;
                        if (k == 0) {
                            f11 *= ((float)j1 - 1.0f) * 0.1f + 1.0f;
                        }
                        int color = (Integer)entity.m_20088_().m_135370_(SmiteBolt.COLOR);
                        float r = (float)(color >>> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >>> 8 & 0xFF) / 255.0f;
                        float b = (float)(color & 0xFF) / 255.0f;
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, false, false, true, false);
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, true, false, true, true);
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, true, true, false, true);
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, false, true, false, false);
                    }
                }
            }
            matrixStack.m_85849_();
        }

        private static void quad(Matrix4f matrix, VertexConsumer vertexConsumer, float x, float z, int y, float p_115278_, float p_115279_, float r, float g, float b, float p_115283_, float p_115284_, boolean p_115285_, boolean p_115286_, boolean p_115287_, boolean p_115288_) {
            vertexConsumer.m_85982_(matrix, x + (p_115285_ ? p_115284_ : -p_115284_), (float)(y * 16), z + (p_115286_ ? p_115284_ : -p_115284_)).m_85950_(r, g, b, 0.3f).m_5752_();
            vertexConsumer.m_85982_(matrix, p_115278_ + (p_115285_ ? p_115283_ : -p_115283_), (float)((y + 1) * 16), p_115279_ + (p_115286_ ? p_115283_ : -p_115283_)).m_85950_(r, g, b, 0.3f).m_5752_();
            vertexConsumer.m_85982_(matrix, p_115278_ + (p_115287_ ? p_115283_ : -p_115283_), (float)((y + 1) * 16), p_115279_ + (p_115288_ ? p_115283_ : -p_115283_)).m_85950_(r, g, b, 0.3f).m_5752_();
            vertexConsumer.m_85982_(matrix, x + (p_115287_ ? p_115284_ : -p_115284_), (float)(y * 16), z + (p_115288_ ? p_115284_ : -p_115284_)).m_85950_(r, g, b, 0.3f).m_5752_();
        }
    }
}

