/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.eyesore;

import iskallia.vault.entity.VaultBoss;
import iskallia.vault.entity.ai.eyesore.BasicAttackTask;
import iskallia.vault.entity.ai.eyesore.EyesorePath;
import iskallia.vault.entity.ai.eyesore.LaserAttackTask;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EyesoreEntity
extends Ghast
implements VaultBoss {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(EyesoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LASER_TARGET = SynchedEntityData.m_135353_(EyesoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final ServerBossEvent bossInfo;
    public EyesorePath path = new EyesorePath();
    public BasicAttackTask<EyesoreEntity> basicAttack = new BasicAttackTask<EyesoreEntity>(this);
    public LaserAttackTask laserAttack = new LaserAttackTask(this);

    public EyesoreEntity(EntityType<? extends Ghast> type, Level worldIn) {
        super(type, worldIn);
        this.bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6);
        this.f_19794_ = true;
        this.m_21530_();
    }

    public State getState() {
        Integer ordinal = (Integer)this.f_19804_.m_135370_(STATE);
        return State.values()[ordinal];
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    protected void m_7625_(@Nonnull DamageSource damageSource, boolean attackedRecently) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)State.NORMAL.ordinal());
        this.f_19804_.m_135372_(LASER_TARGET, (Object)0);
    }

    protected void m_8099_() {
    }

    @Override
    public ServerBossEvent getServerBossInfo() {
        return this.bossInfo;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8119_() {
        LivingEntity target;
        if (!this.f_19853_.f_46443_) {
            if (this.laserAttack.isFinished()) {
                if (this.f_19796_.nextInt(100) == 0) {
                    this.laserAttack.reset();
                }
            } else {
                this.laserAttack.tick();
            }
            this.path.tick(this);
        }
        int id = (Integer)this.m_20088_().m_135370_(LASER_TARGET);
        Entity entity = this.m_20193_().m_6815_(id);
        LivingEntity livingEntity = target = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (target != null) {
            this.lookAtTarget(target);
        }
        super.m_8119_();
    }

    protected void lookAtTarget(LivingEntity target) {
        this.m_146926_(this.getTargetPitch(target));
        this.f_20885_ = this.getTargetYaw(target);
    }

    private double getEyePosition(Entity entity) {
        return entity instanceof LivingEntity ? entity.m_20188_() : (entity.m_142469_().f_82289_ + entity.m_142469_().f_82292_) / 2.0;
    }

    protected float getTargetPitch(LivingEntity target) {
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = this.getEyePosition((Entity)target) - this.m_20188_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        return (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
    }

    protected float getTargetYaw(LivingEntity target) {
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20189_() - this.m_20189_();
        return (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public void m_6123_(@Nonnull Player playerEntity) {
        if (!(playerEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)playerEntity;
        Vec3 posPlayer = player.m_20182_();
        Vec3 posEyesore = this.m_20182_();
        int damage = 10;
        int knockbackStrength = 5;
        player.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)damage);
        player.m_147240_((double)knockbackStrength, posEyesore.f_82479_ - posPlayer.f_82479_, posEyesore.f_82481_ - posPlayer.f_82481_);
    }

    @Nonnull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public SoundEvent m_5592_() {
        return super.m_5592_();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11895_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.5f;
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_(Attributes.f_22284_, 2.0);
    }

    public static enum State {
        NORMAL,
        GIVING_BIRTH;

    }
}

