/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.guardian;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.entity.entity.guardian.FixedArrowEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CrossbowHelper {
    public static void performShooting(Level pLevel, LivingEntity pShooter, InteractionHand pUsedHand, ItemStack pCrossbowStack, float pVelocity, float pInaccuracy) {
        List<ItemStack> list = CrossbowHelper.getChargedProjectiles(pCrossbowStack);
        float[] afloat = CrossbowHelper.getShotPitches(pShooter.m_21187_());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = pShooter instanceof Player && ((Player)pShooter).m_150110_().f_35937_;
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                CrossbowHelper.shootProjectile(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i], flag, pVelocity, pInaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                CrossbowHelper.shootProjectile(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i], flag, pVelocity, pInaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CrossbowHelper.shootProjectile(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i], flag, pVelocity, pInaccuracy, 10.0f);
        }
        CrossbowHelper.onCrossbowShot(pLevel, pShooter, pCrossbowStack);
    }

    private static void onCrossbowShot(Level pLevel, LivingEntity pShooter, ItemStack pCrossbowStack) {
        if (pShooter instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pShooter;
            if (!pLevel.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayer, pCrossbowStack);
            }
            serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)pCrossbowStack.m_41720_()));
        }
        CrossbowHelper.clearChargedProjectiles(pCrossbowStack);
    }

    private static void clearChargedProjectiles(ItemStack pCrossbowStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 9);
            listtag.clear();
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
        }
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack pCrossbowStack) {
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("ChargedProjectiles", 9)) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundtag1));
            }
        }
        return list;
    }

    private static float[] getShotPitches(Random pRandom) {
        boolean flag = pRandom.nextBoolean();
        return new float[]{1.0f, CrossbowHelper.getRandomShotPitch(flag, pRandom), CrossbowHelper.getRandomShotPitch(!flag, pRandom)};
    }

    private static float getRandomShotPitch(boolean pIsHighPitched, Random pRandom) {
        float f = pIsHighPitched ? 0.63f : 0.43f;
        return 1.0f / (pRandom.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void shootProjectile(Level pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pCrossbowStack, ItemStack pAmmoStack, float pSoundPitch, boolean pIsCreativeMode, float pVelocity, float pInaccuracy, float pProjectileAngle) {
        if (!pLevel.f_46443_) {
            AbstractArrow projectile;
            boolean flag = pAmmoStack.m_150930_(Items.f_42688_);
            if (flag) {
                projectile = new FireworkRocketEntity(pLevel, pAmmoStack, (Entity)pShooter, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.15f, pShooter.m_20189_(), true);
            } else {
                projectile = CrossbowHelper.getArrow(pLevel, pShooter, pCrossbowStack, pAmmoStack);
                if (pIsCreativeMode || pProjectileAngle != 0.0f) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (pShooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowattackmob = (CrossbowAttackMob)pShooter;
                crossbowattackmob.m_5811_(crossbowattackmob.m_5448_(), pCrossbowStack, (Projectile)projectile, pProjectileAngle);
            } else {
                Vec3 vec31 = pShooter.m_20289_(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vec31), pProjectileAngle, true);
                Vec3 vec3 = pShooter.m_20252_(1.0f);
                Vector3f vector3f = new Vector3f(vec3);
                vector3f.m_122251_(quaternion);
                projectile.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), pVelocity, pInaccuracy);
            }
            pCrossbowStack.m_41622_(flag ? 3 : 1, pShooter, p_40858_ -> p_40858_.m_21190_(pHand));
            pLevel.m_7967_((Entity)projectile);
            pLevel.m_6263_((Player)null, pShooter.m_20185_(), pShooter.m_20186_(), pShooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    private static AbstractArrow getArrow(Level pLevel, LivingEntity pLivingEntity, ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        FixedArrowEntity abstractarrow = new FixedArrowEntity(pLevel, pLivingEntity, pCrossbowStack);
        if (pLivingEntity instanceof Player) {
            abstractarrow.m_36762_(true);
        }
        abstractarrow.m_36740_(SoundEvents.f_11840_);
        abstractarrow.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)pCrossbowStack);
        if (i > 0) {
            abstractarrow.m_36767_((byte)i);
        }
        return abstractarrow;
    }
}

