/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.mushroom;

import iskallia.vault.entity.entity.mushroom.MushroomEntity;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LevishroomEntity
extends MushroomEntity
implements IAnimatable {
    protected static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("animation.levishroom.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("animation.levishroom.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder BITE_ANIM = new AnimationBuilder().addAnimation("animation.levishroom.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public LevishroomEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
    }

    @Override
    public int getTier() {
        return -1;
    }

    public boolean m_7327_(Entity target) {
        if (!super.m_7327_(target)) {
            return false;
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if ((double)this.f_19853_.f_46441_.nextFloat() <= 0.4) {
                livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, 2, true, true));
            }
        }
        return true;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 5.0f, this::walkAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Idle", 5.0f, this::idleAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Attack", 5.0f, this::attackAnimController));
    }

    private PlayState idleAnimController(AnimationEvent<LevishroomEntity> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(IDLE_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState walkAnimController(AnimationEvent<LevishroomEntity> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(WALK_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState attackAnimController(AnimationEvent<LevishroomEntity> event) {
        if (this.f_20921_ != 0.0f) {
            event.getController().setAnimation(BITE_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

